/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.event.ProgressInputStream;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.utils.Pair;

public class InstrumentHttpResponseContentStage
implements RequestPipeline<Pair<SdkHttpFullRequest, HttpResponse>, Pair<SdkHttpFullRequest, HttpResponse>> {
    private static final Log log = LogFactory.getLog(InstrumentHttpResponseContentStage.class);

    @Override
    public Pair<SdkHttpFullRequest, HttpResponse> execute(Pair<SdkHttpFullRequest, HttpResponse> input, RequestExecutionContext context) throws Exception {
        ProgressListener listener = context.requestConfig().getProgressListener();
        HttpResponse httpResponse = (HttpResponse)input.right();
        InputStream is = ((HttpResponse)input.right()).getContent();
        if (is != null) {
            httpResponse.setContent(ProgressInputStream.inputStreamForResponse(is, listener));
        }
        try {
            Optional.ofNullable(httpResponse.getHeaders().get("Content-Length")).map(Long::parseLong).ifPresent(l -> SdkProgressPublisher.publishResponseContentLength(listener, l));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Cannot parse the Content-Length header of the response.");
        }
        return input;
    }
}

