/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.DefaultSdkHttpFullRequest;
import software.amazon.awssdk.http.HandlerContextKey;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;

public class SdkHttpFullRequestAdapter {
    public static SdkHttpFullRequest toHttpFullRequest(Request<?> request) {
        return (SdkHttpFullRequest)SdkHttpFullRequestAdapter.toMutableHttpFullRequest(request).build();
    }

    public static SdkHttpFullRequest.Builder toMutableHttpFullRequest(Request<?> request) {
        return DefaultSdkHttpFullRequest.builder().content(request.getContent()).httpMethod(SdkHttpMethod.fromValue((String)request.getHttpMethod().name())).headers((Map)SdkHttpFullRequestAdapter.adaptHeaders(request.getHeaders())).queryParameters((Map)request.getParameters()).endpoint(request.getEndpoint()).resourcePath(request.getResourcePath()).handlerContext((HandlerContextKey)AwsHandlerKeys.SERVICE_NAME, request.getServiceName());
    }

    private static Map<String, List<String>> adaptHeaders(Map<String, String> headers) {
        HashMap<String, List<String>> adapated = new HashMap<String, List<String>>(headers.size());
        headers.forEach((k, v) -> adapated.put((String)k, Collections.singletonList(v)));
        return adapated;
    }
}

