/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XpathUtils;
import software.amazon.awssdk.utils.IoUtils;

@SdkProtectedApi
public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        AmazonServiceException ase = this.createAse(errorResponse);
        if (ase == null) {
            throw new SdkClientException("Unable to unmarshall error response from service");
        }
        ase.setHttpHeaders(errorResponse.getHeaders());
        if (StringUtils.isNullOrEmpty(ase.getErrorCode())) {
            ase.setErrorCode(errorResponse.getStatusCode() + " " + errorResponse.getStatusText());
        }
        return ase;
    }

    private AmazonServiceException createAse(HttpResponse errorResponse) throws Exception {
        Document document = this.documentFromContent(errorResponse.getContent(), this.idString(errorResponse));
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    private Document documentFromContent(InputStream content, String idString) throws ParserConfigurationException, SAXException, IOException {
        try {
            return this.parseXml(this.contentToString(content, idString), idString);
        }
        catch (Exception e) {
            return XpathUtils.documentFrom("<empty/>");
        }
    }

    private String contentToString(InputStream content, String idString) throws Exception {
        try {
            return IoUtils.toString((InputStream)content);
        }
        catch (Exception e) {
            LOG.info((Object)String.format("Unable to read input stream to string (%s)", idString), (Throwable)e);
            throw e;
        }
    }

    private Document parseXml(String xml, String idString) throws Exception {
        try {
            return XpathUtils.documentFrom(xml);
        }
        catch (Exception e) {
            LOG.info((Object)String.format("Unable to parse HTTP response (%s) content to XML document '%s' ", idString, xml), (Throwable)e);
            throw e;
        }
    }

    private String idString(HttpResponse errorResponse) {
        StringBuilder idString = new StringBuilder();
        try {
            errorResponse.getRequest().getFirstHeaderValue("amz-sdk-invocation-id").ifPresent(h -> idString.append("Invocation Id:").append((String)h));
            if (errorResponse.getHeaders().containsKey("x-amzn-RequestId")) {
                if (idString.length() > 0) {
                    idString.append(", ");
                }
                idString.append("Request Id:").append(errorResponse.getHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (NullPointerException npe) {
            LOG.info((Object)"Error getting Request or Invocation ID from response", (Throwable)npe);
        }
        return idString.length() > 0 ? idString.toString() : "Unknown";
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

