/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client.builder;

import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.DefaultCredentialsProvider;
import software.amazon.awssdk.client.builder.ClientAsyncHttpConfiguration;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.ClientHttpConfiguration;
import software.amazon.awssdk.client.builder.ExecutorProvider;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.ClientOverrideConfiguration;
import software.amazon.awssdk.config.ImmutableAsyncClientConfiguration;
import software.amazon.awssdk.config.ImmutableSyncClientConfiguration;
import software.amazon.awssdk.config.MutableClientConfiguration;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.GlobalClientConfigurationDefaults;
import software.amazon.awssdk.handlers.HandlerChainFactory;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpClientFactory;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClientFactory;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.loader.DefaultSdkAsyncHttpClientFactory;
import software.amazon.awssdk.http.loader.DefaultSdkHttpClientFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.util.EndpointUtils;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public abstract class DefaultClientBuilder<B extends ClientBuilder<B, C>, C>
implements ClientBuilder<B, C> {
    private static final String DEFAULT_ENDPOINT_PROTOCOL = "https";
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private static final SdkHttpClientFactory DEFAULT_HTTP_CLIENT_FACTORY = new DefaultSdkHttpClientFactory();
    private static final SdkAsyncHttpClientFactory DEFAULT_ASYNC_HTTP_CLIENT_FACTORY = new DefaultSdkAsyncHttpClientFactory();
    private final SdkHttpClientFactory defaultHttpClientFactory;
    private final SdkAsyncHttpClientFactory defaultAsyncHttpClientFactory;
    private MutableClientConfiguration mutableClientConfiguration = new MutableClientConfiguration();
    private Region region;
    private ExecutorProvider asyncExecutorProvider;
    private ClientHttpConfiguration httpConfiguration = (ClientHttpConfiguration)ClientHttpConfiguration.builder().build();
    private ClientAsyncHttpConfiguration asyncHttpConfiguration = (ClientAsyncHttpConfiguration)ClientAsyncHttpConfiguration.builder().build();

    protected DefaultClientBuilder() {
        this(DEFAULT_HTTP_CLIENT_FACTORY, DEFAULT_ASYNC_HTTP_CLIENT_FACTORY);
    }

    @SdkTestInternalApi
    protected DefaultClientBuilder(SdkHttpClientFactory defaultHttpClientFactory, SdkAsyncHttpClientFactory defaultAsyncHttpClientFactory) {
        this.defaultHttpClientFactory = defaultHttpClientFactory;
        this.defaultAsyncHttpClientFactory = defaultAsyncHttpClientFactory;
    }

    public final C build() {
        return this.buildClient();
    }

    protected abstract C buildClient();

    protected abstract String serviceEndpointPrefix();

    protected ClientConfigurationDefaults serviceDefaults() {
        return new ClientConfigurationDefaults(){};
    }

    protected AttributeMap serviceSpecificHttpConfig() {
        return AttributeMap.empty();
    }

    protected final Region signingRegion() {
        return ServiceMetadata.of(this.serviceEndpointPrefix()).signingRegion(this.resolveRegion().orElseThrow(() -> new IllegalStateException("The signing region could not be determined.")));
    }

    protected final ImmutableSyncClientConfiguration syncClientConfiguration() {
        MutableClientConfiguration configuration = this.mutableClientConfiguration.clone();
        this.builderDefaults().applySyncDefaults(configuration);
        this.serviceDefaults().applySyncDefaults(configuration);
        new GlobalClientConfigurationDefaults().applySyncDefaults(configuration);
        this.applySdkHttpClient(configuration);
        return new ImmutableSyncClientConfiguration(configuration);
    }

    private void applySdkHttpClient(MutableClientConfiguration config) {
        config.httpClient(this.resolveSdkHttpClient());
    }

    private SdkHttpClient resolveSdkHttpClient() {
        return this.httpConfiguration.toEither().map(e -> (SdkHttpClient)e.map(x$0 -> new NonManagedSdkHttpClient((SdkHttpClient)x$0), factory -> factory.createHttpClientWithDefaults(this.serviceSpecificHttpConfig()))).orElseGet(() -> this.defaultHttpClientFactory.createHttpClientWithDefaults(this.serviceSpecificHttpConfig()));
    }

    private void applySdkAsyncHttpClient(MutableClientConfiguration config) {
        config.asyncHttpClient(this.resolveSdkAsyncHttpClient());
    }

    private SdkAsyncHttpClient resolveSdkAsyncHttpClient() {
        return this.asyncHttpConfiguration.toEither().map(e -> (SdkAsyncHttpClient)e.map(NonManagedSdkAsyncHttpClient::new, factory -> factory.createHttpClientWithDefaults(this.serviceSpecificHttpConfig()))).orElseGet(() -> this.defaultAsyncHttpClientFactory.createHttpClientWithDefaults(this.serviceSpecificHttpConfig()));
    }

    protected final ImmutableAsyncClientConfiguration asyncClientConfiguration() {
        MutableClientConfiguration configuration = this.mutableClientConfiguration.clone();
        this.builderDefaults().applyAsyncDefaults(configuration);
        this.serviceDefaults().applyAsyncDefaults(configuration);
        new GlobalClientConfigurationDefaults().applyAsyncDefaults(configuration);
        this.applySdkAsyncHttpClient(configuration);
        return new ImmutableAsyncClientConfiguration(configuration);
    }

    private ClientConfigurationDefaults builderDefaults() {
        return new ClientConfigurationDefaults(){

            @Override
            protected URI getEndpointDefault() {
                return DefaultClientBuilder.this.resolveEndpoint().orElse(null);
            }

            @Override
            protected AwsCredentialsProvider getCredentialsDefault() {
                return new DefaultCredentialsProvider();
            }

            @Override
            protected ScheduledExecutorService getAsyncExecutorDefault() {
                return Optional.ofNullable(DefaultClientBuilder.this.asyncExecutorProvider).map(Supplier::get).orElse(null);
            }

            @Override
            protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
                new HandlerChainFactory().getGlobalHandlers().forEach(builder::addRequestListener);
            }
        };
    }

    protected Optional<Region> resolveRegion() {
        return this.region != null ? Optional.of(this.region) : this.regionFromDefaultProvider();
    }

    private Optional<URI> resolveEndpoint() {
        URI configuredEndpoint = this.mutableClientConfiguration.endpoint();
        return configuredEndpoint != null ? Optional.of(configuredEndpoint) : this.endpointFromRegion();
    }

    private Optional<Region> regionFromDefaultProvider() {
        return this.useRegionProviderChain() ? Optional.ofNullable(DEFAULT_REGION_PROVIDER.getRegion()) : Optional.empty();
    }

    private boolean useRegionProviderChain() {
        Boolean configuredToUseRegionProviderChain = this.mutableClientConfiguration.overrideConfiguration().advancedOption(AdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION);
        return configuredToUseRegionProviderChain != null ? configuredToUseRegionProviderChain : true;
    }

    private Optional<URI> endpointFromRegion() {
        return this.resolveRegion().map(r -> EndpointUtils.buildEndpoint(DEFAULT_ENDPOINT_PROTOCOL, this.serviceEndpointPrefix(), r));
    }

    @Override
    public final B region(Region region) {
        this.region = region;
        return this.thisBuilder();
    }

    public final void setRegion(Region region) {
        this.region(region);
    }

    @Override
    public B endpointOverride(URI endpointOverride) {
        this.mutableClientConfiguration.endpoint(endpointOverride);
        return this.thisBuilder();
    }

    public void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride(endpointOverride);
    }

    public B asyncExecutorProvider(ExecutorProvider asyncExecutorProvider) {
        this.asyncExecutorProvider = asyncExecutorProvider;
        return this.thisBuilder();
    }

    public void setAsyncExecutorProvider(ExecutorProvider asyncExecutorProvider) {
        this.asyncExecutorProvider(asyncExecutorProvider);
    }

    @Override
    public final B overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.mutableClientConfiguration.overrideConfiguration(overrideConfiguration);
        return this.thisBuilder();
    }

    public final void setOverrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.overrideConfiguration(overrideConfiguration);
    }

    public final B httpConfiguration(ClientHttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
        return this.thisBuilder();
    }

    public final void setHttpConfiguration(ClientHttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public final B asyncHttpConfiguration(ClientAsyncHttpConfiguration asyncHttpConfiguration) {
        this.asyncHttpConfiguration = asyncHttpConfiguration;
        return this.thisBuilder();
    }

    public final void setAsyncHttpConfiguration(ClientAsyncHttpConfiguration asyncHttpConfiguration) {
        this.asyncHttpConfiguration = asyncHttpConfiguration;
    }

    @Override
    public final B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.mutableClientConfiguration.credentialsProvider(credentialsProvider);
        return this.thisBuilder();
    }

    public final void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider(credentialsProvider);
    }

    protected final B thisBuilder() {
        return (B)this;
    }

    @SdkTestInternalApi
    static class NonManagedSdkAsyncHttpClient
    implements SdkAsyncHttpClient {
        private final SdkAsyncHttpClient delegate;

        NonManagedSdkAsyncHttpClient(SdkAsyncHttpClient delegate) {
            this.delegate = (SdkAsyncHttpClient)Validate.paramNotNull((Object)delegate, (String)"SdkAsyncHttpClient");
        }

        public AbortableRunnable prepareRequest(SdkHttpRequest request, SdkRequestContext context, SdkHttpRequestProvider requestProvider, SdkHttpResponseHandler handler) {
            return this.delegate.prepareRequest(request, context, requestProvider, handler);
        }

        public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
            return this.delegate.getConfigurationValue(key);
        }

        public void close() throws Exception {
        }
    }

    @SdkTestInternalApi
    static class NonManagedSdkHttpClient
    implements SdkHttpClient {
        private final SdkHttpClient delegate;

        private NonManagedSdkHttpClient(SdkHttpClient delegate) {
            this.delegate = (SdkHttpClient)Validate.paramNotNull((Object)delegate, (String)"SdkHttpClient");
        }

        public AbortableCallable<SdkHttpFullResponse> prepareRequest(SdkHttpFullRequest request, SdkRequestContext requestContext) {
            return this.delegate.prepareRequest(request, requestContext);
        }

        public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
            return this.delegate.getConfigurationValue(key);
        }

        public void close() throws Exception {
        }
    }
}

