/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.Protocol;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.SignerFactory;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.loader.DefaultSdkHttpClientFactory;
import software.amazon.awssdk.internal.auth.DefaultSignerProvider;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.runtime.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Validate;

@NotThreadSafe
@SdkProtectedApi
@ReviewBeforeRelease(value="Remove when S3 is migrated to new builder pattern")
public abstract class AwsClientBuilder<SubclassT extends AwsClientBuilder, TypeToBuildT> {
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private final AwsRegionProvider regionProvider;
    private AwsCredentialsProvider credentials;
    private LegacyClientConfiguration clientConfig;
    private RequestMetricCollector metricsCollector;
    private Region region;
    private List<RequestHandler> requestHandlers;
    private EndpointConfiguration endpointConfiguration;

    protected AwsClientBuilder() {
        this(DEFAULT_REGION_PROVIDER);
    }

    @SdkTestInternalApi
    protected AwsClientBuilder(AwsRegionProvider regionProvider) {
        this.regionProvider = regionProvider;
    }

    public final AwsCredentialsProvider getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(AwsCredentialsProvider credentialsProvider) {
        this.credentials = credentialsProvider;
    }

    public final SubclassT withCredentials(AwsCredentialsProvider credentialsProvider) {
        this.setCredentials(credentialsProvider);
        return this.getSubclass();
    }

    private AwsCredentialsProvider resolveCredentials() {
        return this.credentials == null ? new DefaultCredentialsProvider() : this.credentials;
    }

    public final LegacyClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    public final void setClientConfiguration(LegacyClientConfiguration config) {
        this.clientConfig = config;
    }

    public final SubclassT withClientConfiguration(LegacyClientConfiguration config) {
        this.setClientConfiguration(config);
        return this.getSubclass();
    }

    private LegacyClientConfiguration resolveClientConfiguration() {
        return this.clientConfig == null ? new LegacyClientConfiguration() : new LegacyClientConfiguration(this.clientConfig);
    }

    public final RequestMetricCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public final void setMetricsCollector(RequestMetricCollector metrics) {
        this.metricsCollector = metrics;
    }

    public final SubclassT withMetricsCollector(RequestMetricCollector metrics) {
        this.setMetricsCollector(metrics);
        return this.getSubclass();
    }

    public final String getRegion() {
        return this.region == null ? null : this.region.value();
    }

    public final void setRegion(String region) {
        this.withRegion(Region.of(region));
    }

    public SubclassT withRegion(Region region) {
        this.region = region;
        return this.getSubclass();
    }

    public final EndpointConfiguration getEndpoint() {
        return this.endpointConfiguration;
    }

    public final void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.withEndpointConfiguration(endpointConfiguration);
    }

    public final SubclassT withEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this.getSubclass();
    }

    public final List<RequestHandler> getRequestHandlers() {
        return this.requestHandlers == null ? null : Collections.unmodifiableList(this.requestHandlers);
    }

    public final void setRequestHandlers(RequestHandler ... handlers) {
        this.requestHandlers = Arrays.asList(handlers);
    }

    public final SubclassT withRequestHandlers(RequestHandler ... handlers) {
        this.setRequestHandlers(handlers);
        return this.getSubclass();
    }

    private List<RequestHandler> resolveRequestHandlers() {
        return this.requestHandlers == null ? new ArrayList<RequestHandler>() : new ArrayList<RequestHandler>(this.requestHandlers);
    }

    private Region resolveSigningRegion() {
        if (this.endpointConfiguration != null) {
            return Region.of(this.endpointConfiguration.getSigningRegion());
        }
        return this.region != null ? this.region : this.determineRegionFromRegionProvider();
    }

    public abstract TypeToBuildT build();

    public abstract String getServiceName();

    public abstract String getEndpointPrefix();

    protected final AwsSyncClientParams getSyncClientParams() {
        return new SyncBuilderParams();
    }

    private Region determineRegionFromRegionProvider() {
        try {
            return this.regionProvider.getRegion();
        }
        catch (SdkClientException e) {
            return null;
        }
    }

    protected final SubclassT getSubclass() {
        return (SubclassT)this;
    }

    protected class SyncBuilderParams
    extends AwsAsyncClientParams {
        private final LegacyClientConfiguration clientConfig;
        private final AwsCredentialsProvider credentials;
        private final RequestMetricCollector metricsCollector;
        private final List<RequestHandler> requestHandlers;
        private final Region signingRegion;

        protected SyncBuilderParams() {
            this.clientConfig = AwsClientBuilder.this.resolveClientConfiguration();
            this.credentials = AwsClientBuilder.this.resolveCredentials();
            this.metricsCollector = AwsClientBuilder.this.metricsCollector;
            this.requestHandlers = AwsClientBuilder.this.resolveRequestHandlers();
            this.signingRegion = AwsClientBuilder.this.resolveSigningRegion();
            this.validateParams();
        }

        private void validateParams() {
            Validate.validState((AwsClientBuilder.this.region == null || AwsClientBuilder.this.endpointConfiguration == null ? 1 : 0) != 0, (String)"Only one of Region or EndpointConfiguration may be set.", (Object[])new Object[0]);
            Validate.validState((this.signingRegion != null ? 1 : 0) != 0, (String)"Signing region could not be determined. Please specify the region or endpoint.", (Object[])new Object[0]);
            Validate.validState((this.credentials != null ? 1 : 0) != 0, (String)"Credentials could not be determined.", (Object[])new Object[0]);
        }

        @Override
        public AwsCredentialsProvider getCredentialsProvider() {
            return this.credentials;
        }

        @Override
        public LegacyClientConfiguration getClientConfiguration() {
            return this.clientConfig;
        }

        @Override
        public RequestMetricCollector getRequestMetricCollector() {
            return this.metricsCollector;
        }

        @Override
        public List<RequestHandler> getRequestHandlers() {
            return this.requestHandlers;
        }

        @Override
        public SignerProvider getSignerProvider() {
            Signer signer = SignerFactory.getSigner(AwsClientBuilder.this.getServiceName(), this.signingRegion.value());
            return new DefaultSignerProvider(signer);
        }

        @Override
        public URI getEndpoint() {
            if (AwsClientBuilder.this.endpointConfiguration != null) {
                return URI.create(AwsClientBuilder.this.endpointConfiguration.getServiceEndpoint());
            }
            return new DefaultServiceEndpointBuilder(AwsClientBuilder.this.getEndpointPrefix(), Protocol.HTTPS.toString()).withRegion(this.signingRegion).getServiceEndpoint();
        }

        @Override
        public ScheduledExecutorService getExecutor() {
            throw new UnsupportedOperationException("ExecutorService is not used for sync client.");
        }

        @Override
        public SdkHttpClient sdkHttpClient() {
            return new DefaultSdkHttpClientFactory().createHttpClientWithDefaults(AttributeMap.empty());
        }
    }

    public static final class EndpointConfiguration {
        private final String serviceEndpoint;
        private final String signingRegion;

        public EndpointConfiguration(String serviceEndpoint, String signingRegion) {
            this.serviceEndpoint = serviceEndpoint;
            this.signingRegion = signingRegion;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public String getSigningRegion() {
            return this.signingRegion;
        }
    }
}

