/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.profile.internal;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.AllProfiles;
import software.amazon.awssdk.auth.profile.internal.BasicProfile;
import software.amazon.awssdk.auth.profile.internal.ProfileStaticCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.securitytoken.ProfileCredentialsService;
import software.amazon.awssdk.auth.profile.internal.securitytoken.RoleInfo;
import software.amazon.awssdk.util.StringUtils;

@SdkInternalApi
@Immutable
public class ProfileAssumeRoleCredentialsProvider
implements AwsCredentialsProvider {
    private final AllProfiles allProfiles;
    private final BasicProfile profile;
    private final ProfileCredentialsService profileCredentialsService;
    private final AwsCredentialsProvider assumeRoleCredentialsProvider;

    public ProfileAssumeRoleCredentialsProvider(ProfileCredentialsService profileCredentialsService, AllProfiles allProfiles, BasicProfile profile) {
        this.allProfiles = allProfiles;
        this.profile = profile;
        this.profileCredentialsService = profileCredentialsService;
        this.assumeRoleCredentialsProvider = this.fromAssumeRole();
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.assumeRoleCredentialsProvider.getCredentials();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.assumeRoleCredentialsProvider + ")";
    }

    @ReviewBeforeRelease(value="This is gross. It needs to be cleaned up before GA when we refactor profiles.")
    private AwsCredentialsProvider fromAssumeRole() {
        if (StringUtils.isNullOrEmpty(this.profile.getRoleSourceProfile())) {
            throw new SdkClientException(String.format("Unable to load credentials from profile [%s]: Source profile name is not specified", this.profile.getProfileName()));
        }
        BasicProfile sourceProfile = this.allProfiles.getProfile(this.profile.getRoleSourceProfile());
        if (sourceProfile == null) {
            throw new SdkClientException(String.format("Unable to load source profile [%s]: Source profile was not found [%s]", this.profile.getProfileName(), this.profile.getRoleSourceProfile()));
        }
        AwsCredentials credentials = new ProfileStaticCredentialsProvider(sourceProfile).getCredentials();
        String roleSessionName = this.profile.getRoleSessionName() == null ? "aws-sdk-java-" + System.currentTimeMillis() : this.profile.getRoleSessionName();
        RoleInfo roleInfo = new RoleInfo().withRoleArn(this.profile.getRoleArn()).withRoleSessionName(roleSessionName).withExternalId(this.profile.getRoleExternalId()).withLongLivedCredentials(credentials);
        return this.profileCredentialsService.getAssumeRoleCredentialsProvider(roleInfo);
    }
}

