/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.util.Optional;
import software.amazon.awssdk.AwsSystemSetting;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.AwsSessionCredentials;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.SystemSetting;

@SdkInternalApi
abstract class SystemSettingsCredentialsProvider
implements AwsCredentialsProvider {
    SystemSettingsCredentialsProvider() {
    }

    @Override
    public AwsCredentials getCredentials() {
        String accessKey = StringUtils.trim((String)this.loadSetting(AwsSystemSetting.AWS_ACCESS_KEY_ID).orElse(null));
        String secretKey = StringUtils.trim((String)this.loadSetting(AwsSystemSetting.AWS_SECRET_ACCESS_KEY).orElse(null));
        String sessionToken = StringUtils.trim((String)this.loadSetting(AwsSystemSetting.AWS_SESSION_TOKEN).orElse(null));
        if (StringUtils.isEmpty((CharSequence)accessKey)) {
            throw new SdkClientException(String.format("Unable to load credentials from system settings. Access key must be specified either via environment variable (%s) or system property (%s).", AwsSystemSetting.AWS_ACCESS_KEY_ID.environmentVariable(), AwsSystemSetting.AWS_ACCESS_KEY_ID.property()));
        }
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new SdkClientException(String.format("Unable to load credentials from system settings. Secret key must be specified either via environment variable (%s) or system property (%s).", AwsSystemSetting.AWS_SECRET_ACCESS_KEY.environmentVariable(), AwsSystemSetting.AWS_SECRET_ACCESS_KEY.property()));
        }
        return sessionToken == null ? new AwsCredentials(accessKey, secretKey) : new AwsSessionCredentials(accessKey, secretKey, sessionToken);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected abstract Optional<String> loadSetting(SystemSetting var1);
}

