/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.ElasticContainerCredentialsProvider;
import software.amazon.awssdk.auth.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.SystemPropertyCredentialsProvider;

public class DefaultCredentialsProvider
implements AwsCredentialsProvider,
AutoCloseable {
    private static final AwsCredentialsProviderChain DEFAULT_PROVIDER_CHAIN = DefaultCredentialsProvider.createChain(new Builder());
    private final AwsCredentialsProviderChain providerChain;

    public DefaultCredentialsProvider() {
        this.providerChain = DEFAULT_PROVIDER_CHAIN;
    }

    private DefaultCredentialsProvider(Builder builder) {
        this.providerChain = DefaultCredentialsProvider.createChain(builder);
    }

    private static AwsCredentialsProviderChain createChain(Builder builder) {
        AwsCredentialsProvider[] credentialsProviders = new AwsCredentialsProvider[]{new SystemPropertyCredentialsProvider(), new EnvironmentVariableCredentialsProvider(), new ProfileCredentialsProvider(), ElasticContainerCredentialsProvider.builder().asyncCredentialUpdateEnabled(builder.asyncCredentialUpdateEnabled).build(), InstanceProfileCredentialsProvider.builder().asyncCredentialUpdateEnabled(builder.asyncCredentialUpdateEnabled).build()};
        return AwsCredentialsProviderChain.builder().reuseLastProviderEnabled(builder.reuseLastProviderEnabled).credentialsProviders(credentialsProviders).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.providerChain.getCredentials();
    }

    @Override
    public void close() {
        this.providerChain.close();
    }

    public static final class Builder {
        private Boolean reuseLastProviderEnabled = true;
        private Boolean asyncCredentialUpdateEnabled = false;

        private Builder() {
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        public DefaultCredentialsProvider build() {
            return new DefaultCredentialsProvider(this);
        }
    }
}

