/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public final class AwsCredentialsProviderChain
implements AwsCredentialsProvider,
AutoCloseable {
    private static final Logger LOG = Logger.loggerFor(AwsCredentialsProviderChain.class);
    private final List<AwsCredentialsProvider> credentialsProviders;
    private final boolean reuseLastProviderEnabled;
    private volatile AwsCredentialsProvider lastUsedProvider;

    private AwsCredentialsProviderChain(Builder builder) {
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.credentialsProviders = Collections.unmodifiableList((List)Validate.notEmpty((Collection)builder.credentialsProviders, (String)"No credential providers were specified.", (Object[])new Object[0]));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AwsCredentialsProviderChain of(AwsCredentialsProvider ... awsCredentialsProviders) {
        return AwsCredentialsProviderChain.builder().credentialsProviders(awsCredentialsProviders).build();
    }

    @Override
    public AwsCredentials getCredentials() {
        if (this.reuseLastProviderEnabled && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        for (AwsCredentialsProvider provider : this.credentialsProviders) {
            try {
                AwsCredentials credentials = provider.getCredentials();
                LOG.debug(() -> "Loading credentials from " + provider.toString());
                this.lastUsedProvider = provider;
                return credentials;
            }
            catch (RuntimeException e) {
                LOG.debug(() -> "Unable to load credentials from " + provider.toString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        throw new SdkClientException("Unable to load credentials from any of the providers in the chain: " + this);
    }

    @Override
    public void close() {
        this.credentialsProviders.stream().filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).forEach(c -> IoUtils.closeQuietly((AutoCloseable)c, null));
    }

    public String toString() {
        String credentialProviders = this.credentialsProviders.stream().map(Object::toString).collect(Collectors.joining(", "));
        return this.getClass().getSimpleName() + "(" + credentialProviders + ")";
    }

    public static class Builder {
        private Boolean reuseLastProviderEnabled = true;
        private List<AwsCredentialsProvider> credentialsProviders = new ArrayList<AwsCredentialsProvider>();

        private Builder() {
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder credentialsProviders(Collection<? extends AwsCredentialsProvider> credentialsProviders) {
            this.credentialsProviders = new ArrayList<AwsCredentialsProvider>(credentialsProviders);
            return this;
        }

        public Builder credentialsProviders(AwsCredentialsProvider ... credentialsProviders) {
            return this.credentialsProviders(Arrays.asList(credentialsProviders));
        }

        public Builder addCredentialsProvider(AwsCredentialsProvider credentialsProviders) {
            this.credentialsProviders.add(credentialsProviders);
            return this;
        }

        public AwsCredentialsProviderChain build() {
            return new AwsCredentialsProviderChain(this);
        }
    }
}

