/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.LandingZoneSummary;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse;

public class ListLandingZonesIterable
implements SdkIterable<ListLandingZonesResponse> {
    private final ControlTowerClient client;
    private final ListLandingZonesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLandingZonesIterable(ControlTowerClient client, ListLandingZonesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLandingZonesResponseFetcher();
    }

    public Iterator<ListLandingZonesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LandingZoneSummary> landingZones() {
        Function<ListLandingZonesResponse, Iterator> getIterator = response -> {
            if (response != null && response.landingZones() != null) {
                return response.landingZones().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLandingZonesResponseFetcher
    implements SyncPageFetcher<ListLandingZonesResponse> {
        private ListLandingZonesResponseFetcher() {
        }

        public boolean hasNextPage(ListLandingZonesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLandingZonesResponse nextPage(ListLandingZonesResponse previousPage) {
            if (previousPage == null) {
                return ListLandingZonesIterable.this.client.listLandingZones(ListLandingZonesIterable.this.firstRequest);
            }
            return ListLandingZonesIterable.this.client.listLandingZones((ListLandingZonesRequest)((Object)ListLandingZonesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

