/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineSummary;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse;

public class ListEnabledBaselinesPublisher
implements SdkPublisher<ListEnabledBaselinesResponse> {
    private final ControlTowerAsyncClient client;
    private final ListEnabledBaselinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnabledBaselinesPublisher(ControlTowerAsyncClient client, ListEnabledBaselinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnabledBaselinesPublisher(ControlTowerAsyncClient client, ListEnabledBaselinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnabledBaselinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnabledBaselinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnabledBaselineSummary> enabledBaselines() {
        Function<ListEnabledBaselinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.enabledBaselines() != null) {
                return response.enabledBaselines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnabledBaselinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnabledBaselinesResponseFetcher
    implements AsyncPageFetcher<ListEnabledBaselinesResponse> {
        private ListEnabledBaselinesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledBaselinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnabledBaselinesResponse> nextPage(ListEnabledBaselinesResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledBaselinesPublisher.this.client.listEnabledBaselines(ListEnabledBaselinesPublisher.this.firstRequest);
            }
            return ListEnabledBaselinesPublisher.this.client.listEnabledBaselines((ListEnabledBaselinesRequest)((Object)ListEnabledBaselinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

