/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLandingZoneRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, UpdateLandingZoneRequest> {
    private static final SdkField<String> LANDING_ZONE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("landingZoneIdentifier").getter(UpdateLandingZoneRequest.getter(UpdateLandingZoneRequest::landingZoneIdentifier)).setter(UpdateLandingZoneRequest.setter(Builder::landingZoneIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZoneIdentifier").build()}).build();
    private static final SdkField<Document> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("manifest").getter(UpdateLandingZoneRequest.getter(UpdateLandingZoneRequest::manifest)).setter(UpdateLandingZoneRequest.setter(Builder::manifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifest").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(UpdateLandingZoneRequest.getter(UpdateLandingZoneRequest::version)).setter(UpdateLandingZoneRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANDING_ZONE_IDENTIFIER_FIELD, MANIFEST_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("landingZoneIdentifier", LANDING_ZONE_IDENTIFIER_FIELD);
            this.put("manifest", MANIFEST_FIELD);
            this.put("version", VERSION_FIELD);
        }
    });
    private final String landingZoneIdentifier;
    private final Document manifest;
    private final String version;

    private UpdateLandingZoneRequest(BuilderImpl builder) {
        super(builder);
        this.landingZoneIdentifier = builder.landingZoneIdentifier;
        this.manifest = builder.manifest;
        this.version = builder.version;
    }

    public final String landingZoneIdentifier() {
        return this.landingZoneIdentifier;
    }

    public final Document manifest() {
        return this.manifest;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.landingZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLandingZoneRequest)) {
            return false;
        }
        UpdateLandingZoneRequest other = (UpdateLandingZoneRequest)((Object)obj);
        return Objects.equals(this.landingZoneIdentifier(), other.landingZoneIdentifier()) && Objects.equals(this.manifest(), other.manifest()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLandingZoneRequest").add("LandingZoneIdentifier", (Object)this.landingZoneIdentifier()).add("Manifest", (Object)this.manifest()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "landingZoneIdentifier": {
                return Optional.ofNullable(clazz.cast(this.landingZoneIdentifier()));
            }
            case "manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLandingZoneRequest, T> g) {
        return obj -> g.apply((UpdateLandingZoneRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private String landingZoneIdentifier;
        private Document manifest;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLandingZoneRequest model) {
            super(model);
            this.landingZoneIdentifier(model.landingZoneIdentifier);
            this.manifest(model.manifest);
            this.version(model.version);
        }

        public final String getLandingZoneIdentifier() {
            return this.landingZoneIdentifier;
        }

        public final void setLandingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
        }

        @Override
        public final Builder landingZoneIdentifier(String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
            return this;
        }

        public final Document getManifest() {
            return this.manifest;
        }

        public final void setManifest(Document manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(Document manifest) {
            this.manifest = manifest;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLandingZoneRequest build() {
            return new UpdateLandingZoneRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLandingZoneRequest> {
        public Builder landingZoneIdentifier(String var1);

        public Builder manifest(Document var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

