/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.DriftStatusSummary;
import software.amazon.awssdk.services.controltower.model.EnablementStatusSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnabledControlSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnabledControlSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnabledControlSummary.getter(EnabledControlSummary::arn)).setter(EnabledControlSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlIdentifier").getter(EnabledControlSummary.getter(EnabledControlSummary::controlIdentifier)).setter(EnabledControlSummary.setter(Builder::controlIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()}).build();
    private static final SdkField<DriftStatusSummary> DRIFT_STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("driftStatusSummary").getter(EnabledControlSummary.getter(EnabledControlSummary::driftStatusSummary)).setter(EnabledControlSummary.setter(Builder::driftStatusSummary)).constructor(DriftStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatusSummary").build()}).build();
    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusSummary").getter(EnabledControlSummary.getter(EnabledControlSummary::statusSummary)).setter(EnabledControlSummary.setter(Builder::statusSummary)).constructor(EnablementStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(EnabledControlSummary.getter(EnabledControlSummary::targetIdentifier)).setter(EnabledControlSummary.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONTROL_IDENTIFIER_FIELD, DRIFT_STATUS_SUMMARY_FIELD, STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String controlIdentifier;
    private final DriftStatusSummary driftStatusSummary;
    private final EnablementStatusSummary statusSummary;
    private final String targetIdentifier;

    private EnabledControlSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.controlIdentifier = builder.controlIdentifier;
        this.driftStatusSummary = builder.driftStatusSummary;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
    }

    public final String arn() {
        return this.arn;
    }

    public final String controlIdentifier() {
        return this.controlIdentifier;
    }

    public final DriftStatusSummary driftStatusSummary() {
        return this.driftStatusSummary;
    }

    public final EnablementStatusSummary statusSummary() {
        return this.statusSummary;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledControlSummary)) {
            return false;
        }
        EnabledControlSummary other = (EnabledControlSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.controlIdentifier(), other.controlIdentifier()) && Objects.equals(this.driftStatusSummary(), other.driftStatusSummary()) && Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"EnabledControlSummary").add("Arn", (Object)this.arn()).add("ControlIdentifier", (Object)this.controlIdentifier()).add("DriftStatusSummary", (Object)this.driftStatusSummary()).add("StatusSummary", (Object)this.statusSummary()).add("TargetIdentifier", (Object)this.targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "controlIdentifier": {
                return Optional.ofNullable(clazz.cast(this.controlIdentifier()));
            }
            case "driftStatusSummary": {
                return Optional.ofNullable(clazz.cast(this.driftStatusSummary()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnabledControlSummary, T> g) {
        return obj -> g.apply((EnabledControlSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String controlIdentifier;
        private DriftStatusSummary driftStatusSummary;
        private EnablementStatusSummary statusSummary;
        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledControlSummary model) {
            this.arn(model.arn);
            this.controlIdentifier(model.controlIdentifier);
            this.driftStatusSummary(model.driftStatusSummary);
            this.statusSummary(model.statusSummary);
            this.targetIdentifier(model.targetIdentifier);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getControlIdentifier() {
            return this.controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final DriftStatusSummary.Builder getDriftStatusSummary() {
            return this.driftStatusSummary != null ? this.driftStatusSummary.toBuilder() : null;
        }

        public final void setDriftStatusSummary(DriftStatusSummary.BuilderImpl driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary != null ? driftStatusSummary.build() : null;
        }

        @Override
        public final Builder driftStatusSummary(DriftStatusSummary driftStatusSummary) {
            this.driftStatusSummary = driftStatusSummary;
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return this.statusSummary != null ? this.statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public EnabledControlSummary build() {
            return new EnabledControlSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnabledControlSummary> {
        public Builder arn(String var1);

        public Builder controlIdentifier(String var1);

        public Builder driftStatusSummary(DriftStatusSummary var1);

        default public Builder driftStatusSummary(Consumer<DriftStatusSummary.Builder> driftStatusSummary) {
            return this.driftStatusSummary((DriftStatusSummary)((DriftStatusSummary.Builder)DriftStatusSummary.builder().applyMutation(driftStatusSummary)).build());
        }

        public Builder statusSummary(EnablementStatusSummary var1);

        default public Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return this.statusSummary((EnablementStatusSummary)((EnablementStatusSummary.Builder)EnablementStatusSummary.builder().applyMutation(statusSummary)).build());
        }

        public Builder targetIdentifier(String var1);
    }
}

