/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeViewRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, DescribeViewRequest> {
    private static final SdkField<String> VIEW_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewToken").getter(DescribeViewRequest.getter(DescribeViewRequest::viewToken)).setter(DescribeViewRequest.setter(Builder::viewToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ViewToken").build()}).build();
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(DescribeViewRequest.getter(DescribeViewRequest::connectionToken)).setter(DescribeViewRequest.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIEW_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));
    private final String viewToken;
    private final String connectionToken;

    private DescribeViewRequest(BuilderImpl builder) {
        super(builder);
        this.viewToken = builder.viewToken;
        this.connectionToken = builder.connectionToken;
    }

    public final String viewToken() {
        return this.viewToken;
    }

    public final String connectionToken() {
        return this.connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.viewToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeViewRequest)) {
            return false;
        }
        DescribeViewRequest other = (DescribeViewRequest)((Object)obj);
        return Objects.equals(this.viewToken(), other.viewToken()) && Objects.equals(this.connectionToken(), other.connectionToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeViewRequest").add("ViewToken", (Object)this.viewToken()).add("ConnectionToken", (Object)this.connectionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViewToken": {
                return Optional.ofNullable(clazz.cast(this.viewToken()));
            }
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeViewRequest, T> g) {
        return obj -> g.apply((DescribeViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private String viewToken;
        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeViewRequest model) {
            super(model);
            this.viewToken(model.viewToken);
            this.connectionToken(model.connectionToken);
        }

        public final String getViewToken() {
            return this.viewToken;
        }

        public final void setViewToken(String viewToken) {
            this.viewToken = viewToken;
        }

        @Override
        public final Builder viewToken(String viewToken) {
            this.viewToken = viewToken;
            return this;
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeViewRequest build() {
            return new DescribeViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeViewRequest> {
        public Builder viewToken(String var1);

        public Builder connectionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

