/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAllRelatedItemsRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<SearchAllRelatedItemsRequest.Builder, SearchAllRelatedItemsRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(SearchAllRelatedItemsRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchAllRelatedItemsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchAllRelatedItemsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RelatedItemTypeFilter>> FILTERS_FIELD = SdkField
            .<List<RelatedItemTypeFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SearchAllRelatedItemsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedItemTypeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedItemTypeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SearchAllRelatedItemsSort>> SORTS_FIELD = SdkField
            .<List<SearchAllRelatedItemsSort>> builder(MarshallingType.LIST)
            .memberName("sorts")
            .getter(getter(SearchAllRelatedItemsRequest::sorts))
            .setter(setter(Builder::sorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchAllRelatedItemsSort> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchAllRelatedItemsSort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, SORTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<RelatedItemTypeFilter> filters;

    private final List<SearchAllRelatedItemsSort> sorts;

    private SearchAllRelatedItemsRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.sorts = builder.sorts;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of types of related items and their parameters to use for filtering. The filters work as an OR
     * condition: caller gets back related items that match any of the specified filter types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The list of types of related items and their parameters to use for filtering. The filters work as an OR
     *         condition: caller gets back related items that match any of the specified filter types.
     */
    public final List<RelatedItemTypeFilter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sorts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSorts() {
        return sorts != null && !(sorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structured set of sort terms to specify the order in which related items should be returned. Supports sorting
     * by association time or case ID. The sorts work in the order specified: first sort term takes precedence over
     * subsequent terms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSorts} method.
     * </p>
     * 
     * @return A structured set of sort terms to specify the order in which related items should be returned. Supports
     *         sorting by association time or case ID. The sorts work in the order specified: first sort term takes
     *         precedence over subsequent terms.
     */
    public final List<SearchAllRelatedItemsSort> sorts() {
        return sorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSorts() ? sorts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAllRelatedItemsRequest)) {
            return false;
        }
        SearchAllRelatedItemsRequest other = (SearchAllRelatedItemsRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && hasSorts() == other.hasSorts()
                && Objects.equals(sorts(), other.sorts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAllRelatedItemsRequest").add("DomainId", domainId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null)
                .add("Sorts", hasSorts() ? sorts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "sorts":
            return Optional.ofNullable(clazz.cast(sorts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("sorts", SORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAllRelatedItemsRequest, T> g) {
        return obj -> g.apply((SearchAllRelatedItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchAllRelatedItemsRequest> {
        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of types of related items and their parameters to use for filtering. The filters work as an OR
         * condition: caller gets back related items that match any of the specified filter types.
         * </p>
         * 
         * @param filters
         *        The list of types of related items and their parameters to use for filtering. The filters work as an
         *        OR condition: caller gets back related items that match any of the specified filter types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<RelatedItemTypeFilter> filters);

        /**
         * <p>
         * The list of types of related items and their parameters to use for filtering. The filters work as an OR
         * condition: caller gets back related items that match any of the specified filter types.
         * </p>
         * 
         * @param filters
         *        The list of types of related items and their parameters to use for filtering. The filters work as an
         *        OR condition: caller gets back related items that match any of the specified filter types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(RelatedItemTypeFilter... filters);

        /**
         * <p>
         * The list of types of related items and their parameters to use for filtering. The filters work as an OR
         * condition: caller gets back related items that match any of the specified filter types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<RelatedItemTypeFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<RelatedItemTypeFilter>)
         */
        Builder filters(Consumer<RelatedItemTypeFilter.Builder>... filters);

        /**
         * <p>
         * A structured set of sort terms to specify the order in which related items should be returned. Supports
         * sorting by association time or case ID. The sorts work in the order specified: first sort term takes
         * precedence over subsequent terms.
         * </p>
         * 
         * @param sorts
         *        A structured set of sort terms to specify the order in which related items should be returned.
         *        Supports sorting by association time or case ID. The sorts work in the order specified: first sort
         *        term takes precedence over subsequent terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sorts(Collection<SearchAllRelatedItemsSort> sorts);

        /**
         * <p>
         * A structured set of sort terms to specify the order in which related items should be returned. Supports
         * sorting by association time or case ID. The sorts work in the order specified: first sort term takes
         * precedence over subsequent terms.
         * </p>
         * 
         * @param sorts
         *        A structured set of sort terms to specify the order in which related items should be returned.
         *        Supports sorting by association time or case ID. The sorts work in the order specified: first sort
         *        term takes precedence over subsequent terms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sorts(SearchAllRelatedItemsSort... sorts);

        /**
         * <p>
         * A structured set of sort terms to specify the order in which related items should be returned. Supports
         * sorting by association time or case ID. The sorts work in the order specified: first sort term takes
         * precedence over subsequent terms.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsSort.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsSort.Builder#build()} is
         * called immediately and its result is passed to {@link #sorts(List<SearchAllRelatedItemsSort>)}.
         * 
         * @param sorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.SearchAllRelatedItemsSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sorts(java.util.Collection<SearchAllRelatedItemsSort>)
         */
        Builder sorts(Consumer<SearchAllRelatedItemsSort.Builder>... sorts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private String domainId;

        private Integer maxResults;

        private String nextToken;

        private List<RelatedItemTypeFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<SearchAllRelatedItemsSort> sorts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAllRelatedItemsRequest model) {
            super(model);
            domainId(model.domainId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
            sorts(model.sorts);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RelatedItemTypeFilter.Builder> getFilters() {
            List<RelatedItemTypeFilter.Builder> result = SearchAllRelatedItemsRequestFiltersListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<RelatedItemTypeFilter.BuilderImpl> filters) {
            this.filters = SearchAllRelatedItemsRequestFiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<RelatedItemTypeFilter> filters) {
            this.filters = SearchAllRelatedItemsRequestFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(RelatedItemTypeFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<RelatedItemTypeFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> RelatedItemTypeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SearchAllRelatedItemsSort.Builder> getSorts() {
            List<SearchAllRelatedItemsSort.Builder> result = SearchAllRelatedItemsRequestSortsListCopier
                    .copyToBuilder(this.sorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSorts(Collection<SearchAllRelatedItemsSort.BuilderImpl> sorts) {
            this.sorts = SearchAllRelatedItemsRequestSortsListCopier.copyFromBuilder(sorts);
        }

        @Override
        public final Builder sorts(Collection<SearchAllRelatedItemsSort> sorts) {
            this.sorts = SearchAllRelatedItemsRequestSortsListCopier.copy(sorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(SearchAllRelatedItemsSort... sorts) {
            sorts(Arrays.asList(sorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sorts(Consumer<SearchAllRelatedItemsSort.Builder>... sorts) {
            sorts(Stream.of(sorts).map(c -> SearchAllRelatedItemsSort.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAllRelatedItemsRequest build() {
            return new SearchAllRelatedItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
