/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCasesForContactResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<ListCasesForContactResponse.Builder, ListCasesForContactResponse> {
    private static final SdkField<List<CaseSummary>> CASES_FIELD = SdkField
            .<List<CaseSummary>> builder(MarshallingType.LIST)
            .memberName("cases")
            .getter(getter(ListCasesForContactResponse::cases))
            .setter(setter(Builder::cases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCasesForContactResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CASES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CaseSummary> cases;

    private final String nextToken;

    private ListCasesForContactResponse(BuilderImpl builder) {
        super(builder);
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cases property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCases() {
        return cases != null && !(cases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Case summary information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCases} method.
     * </p>
     * 
     * @return A list of Case summary information.
     */
    public final List<CaseSummary> cases() {
        return cases;
    }

    /**
     * <p>
     * The token for the next set of results. This is null if there are no more results to return.
     * </p>
     * 
     * @return The token for the next set of results. This is null if there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCases() ? cases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCasesForContactResponse)) {
            return false;
        }
        ListCasesForContactResponse other = (ListCasesForContactResponse) obj;
        return hasCases() == other.hasCases() && Objects.equals(cases(), other.cases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCasesForContactResponse").add("Cases", hasCases() ? cases() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cases":
            return Optional.ofNullable(clazz.cast(cases()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cases", CASES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCasesForContactResponse, T> g) {
        return obj -> g.apply((ListCasesForContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCasesForContactResponse> {
        /**
         * <p>
         * A list of Case summary information.
         * </p>
         * 
         * @param cases
         *        A list of Case summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(Collection<CaseSummary> cases);

        /**
         * <p>
         * A list of Case summary information.
         * </p>
         * 
         * @param cases
         *        A list of Case summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cases(CaseSummary... cases);

        /**
         * <p>
         * A list of Case summary information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CaseSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connectcases.model.CaseSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CaseSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #cases(List<CaseSummary>)}.
         * 
         * @param cases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CaseSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cases(java.util.Collection<CaseSummary>)
         */
        Builder cases(Consumer<CaseSummary.Builder>... cases);

        /**
         * <p>
         * The token for the next set of results. This is null if there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. This is null if there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private List<CaseSummary> cases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCasesForContactResponse model) {
            super(model);
            cases(model.cases);
            nextToken(model.nextToken);
        }

        public final List<CaseSummary.Builder> getCases() {
            List<CaseSummary.Builder> result = ListCasesForContactResponseCasesListCopier.copyToBuilder(this.cases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCases(Collection<CaseSummary.BuilderImpl> cases) {
            this.cases = ListCasesForContactResponseCasesListCopier.copyFromBuilder(cases);
        }

        @Override
        public final Builder cases(Collection<CaseSummary> cases) {
            this.cases = ListCasesForContactResponseCasesListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseSummary... cases) {
            cases(Arrays.asList(cases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(Consumer<CaseSummary.Builder>... cases) {
            cases(Stream.of(cases).map(c -> CaseSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCasesForContactResponse build() {
            return new ListCasesForContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
