/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Rules that control which options are available in a child field based on the selected value in a parent field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldOptionsCaseRule implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldOptionsCaseRule.Builder, FieldOptionsCaseRule> {
    private static final SdkField<String> PARENT_FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentFieldId").getter(getter(FieldOptionsCaseRule::parentFieldId))
            .setter(setter(Builder::parentFieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentFieldId").build()).build();

    private static final SdkField<String> CHILD_FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("childFieldId").getter(getter(FieldOptionsCaseRule::childFieldId)).setter(setter(Builder::childFieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childFieldId").build()).build();

    private static final SdkField<List<ParentChildFieldOptionsMapping>> PARENT_CHILD_FIELD_OPTIONS_MAPPINGS_FIELD = SdkField
            .<List<ParentChildFieldOptionsMapping>> builder(MarshallingType.LIST)
            .memberName("parentChildFieldOptionsMappings")
            .getter(getter(FieldOptionsCaseRule::parentChildFieldOptionsMappings))
            .setter(setter(Builder::parentChildFieldOptionsMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentChildFieldOptionsMappings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParentChildFieldOptionsMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParentChildFieldOptionsMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_FIELD_ID_FIELD,
            CHILD_FIELD_ID_FIELD, PARENT_CHILD_FIELD_OPTIONS_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parentFieldId;

    private final String childFieldId;

    private final List<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings;

    private FieldOptionsCaseRule(BuilderImpl builder) {
        this.parentFieldId = builder.parentFieldId;
        this.childFieldId = builder.childFieldId;
        this.parentChildFieldOptionsMappings = builder.parentChildFieldOptionsMappings;
    }

    /**
     * <p>
     * The identifier of the parent field that controls options.
     * </p>
     * 
     * @return The identifier of the parent field that controls options.
     */
    public final String parentFieldId() {
        return parentFieldId;
    }

    /**
     * <p>
     * The identifier of the child field whose options are controlled.
     * </p>
     * 
     * @return The identifier of the child field whose options are controlled.
     */
    public final String childFieldId() {
        return childFieldId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParentChildFieldOptionsMappings
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasParentChildFieldOptionsMappings() {
        return parentChildFieldOptionsMappings != null && !(parentChildFieldOptionsMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A mapping between a parent field option value and child field option values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParentChildFieldOptionsMappings}
     * method.
     * </p>
     * 
     * @return A mapping between a parent field option value and child field option values.
     */
    public final List<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings() {
        return parentChildFieldOptionsMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentFieldId());
        hashCode = 31 * hashCode + Objects.hashCode(childFieldId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasParentChildFieldOptionsMappings() ? parentChildFieldOptionsMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldOptionsCaseRule)) {
            return false;
        }
        FieldOptionsCaseRule other = (FieldOptionsCaseRule) obj;
        return Objects.equals(parentFieldId(), other.parentFieldId()) && Objects.equals(childFieldId(), other.childFieldId())
                && hasParentChildFieldOptionsMappings() == other.hasParentChildFieldOptionsMappings()
                && Objects.equals(parentChildFieldOptionsMappings(), other.parentChildFieldOptionsMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FieldOptionsCaseRule")
                .add("ParentFieldId", parentFieldId())
                .add("ChildFieldId", childFieldId())
                .add("ParentChildFieldOptionsMappings",
                        hasParentChildFieldOptionsMappings() ? parentChildFieldOptionsMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parentFieldId":
            return Optional.ofNullable(clazz.cast(parentFieldId()));
        case "childFieldId":
            return Optional.ofNullable(clazz.cast(childFieldId()));
        case "parentChildFieldOptionsMappings":
            return Optional.ofNullable(clazz.cast(parentChildFieldOptionsMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("parentFieldId", PARENT_FIELD_ID_FIELD);
        map.put("childFieldId", CHILD_FIELD_ID_FIELD);
        map.put("parentChildFieldOptionsMappings", PARENT_CHILD_FIELD_OPTIONS_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldOptionsCaseRule, T> g) {
        return obj -> g.apply((FieldOptionsCaseRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldOptionsCaseRule> {
        /**
         * <p>
         * The identifier of the parent field that controls options.
         * </p>
         * 
         * @param parentFieldId
         *        The identifier of the parent field that controls options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFieldId(String parentFieldId);

        /**
         * <p>
         * The identifier of the child field whose options are controlled.
         * </p>
         * 
         * @param childFieldId
         *        The identifier of the child field whose options are controlled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childFieldId(String childFieldId);

        /**
         * <p>
         * A mapping between a parent field option value and child field option values.
         * </p>
         * 
         * @param parentChildFieldOptionsMappings
         *        A mapping between a parent field option value and child field option values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentChildFieldOptionsMappings(Collection<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings);

        /**
         * <p>
         * A mapping between a parent field option value and child field option values.
         * </p>
         * 
         * @param parentChildFieldOptionsMappings
         *        A mapping between a parent field option value and child field option values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentChildFieldOptionsMappings(ParentChildFieldOptionsMapping... parentChildFieldOptionsMappings);

        /**
         * <p>
         * A mapping between a parent field option value and child field option values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMapping.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMapping.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #parentChildFieldOptionsMappings(List<ParentChildFieldOptionsMapping>)}.
         * 
         * @param parentChildFieldOptionsMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.ParentChildFieldOptionsMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentChildFieldOptionsMappings(java.util.Collection<ParentChildFieldOptionsMapping>)
         */
        Builder parentChildFieldOptionsMappings(
                Consumer<ParentChildFieldOptionsMapping.Builder>... parentChildFieldOptionsMappings);
    }

    static final class BuilderImpl implements Builder {
        private String parentFieldId;

        private String childFieldId;

        private List<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldOptionsCaseRule model) {
            parentFieldId(model.parentFieldId);
            childFieldId(model.childFieldId);
            parentChildFieldOptionsMappings(model.parentChildFieldOptionsMappings);
        }

        public final String getParentFieldId() {
            return parentFieldId;
        }

        public final void setParentFieldId(String parentFieldId) {
            this.parentFieldId = parentFieldId;
        }

        @Override
        public final Builder parentFieldId(String parentFieldId) {
            this.parentFieldId = parentFieldId;
            return this;
        }

        public final String getChildFieldId() {
            return childFieldId;
        }

        public final void setChildFieldId(String childFieldId) {
            this.childFieldId = childFieldId;
        }

        @Override
        public final Builder childFieldId(String childFieldId) {
            this.childFieldId = childFieldId;
            return this;
        }

        public final List<ParentChildFieldOptionsMapping.Builder> getParentChildFieldOptionsMappings() {
            List<ParentChildFieldOptionsMapping.Builder> result = ParentChildFieldOptionsMappingListCopier
                    .copyToBuilder(this.parentChildFieldOptionsMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParentChildFieldOptionsMappings(
                Collection<ParentChildFieldOptionsMapping.BuilderImpl> parentChildFieldOptionsMappings) {
            this.parentChildFieldOptionsMappings = ParentChildFieldOptionsMappingListCopier
                    .copyFromBuilder(parentChildFieldOptionsMappings);
        }

        @Override
        public final Builder parentChildFieldOptionsMappings(
                Collection<ParentChildFieldOptionsMapping> parentChildFieldOptionsMappings) {
            this.parentChildFieldOptionsMappings = ParentChildFieldOptionsMappingListCopier.copy(parentChildFieldOptionsMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentChildFieldOptionsMappings(ParentChildFieldOptionsMapping... parentChildFieldOptionsMappings) {
            parentChildFieldOptionsMappings(Arrays.asList(parentChildFieldOptionsMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentChildFieldOptionsMappings(
                Consumer<ParentChildFieldOptionsMapping.Builder>... parentChildFieldOptionsMappings) {
            parentChildFieldOptionsMappings(Stream.of(parentChildFieldOptionsMappings)
                    .map(c -> ParentChildFieldOptionsMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FieldOptionsCaseRule build() {
            return new FieldOptionsCaseRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
