/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of what case and related item data is published through the case event stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventIncludedData implements SdkPojo, Serializable,
        ToCopyableBuilder<EventIncludedData.Builder, EventIncludedData> {
    private static final SdkField<CaseEventIncludedData> CASE_DATA_FIELD = SdkField
            .<CaseEventIncludedData> builder(MarshallingType.SDK_POJO).memberName("caseData")
            .getter(getter(EventIncludedData::caseData)).setter(setter(Builder::caseData))
            .constructor(CaseEventIncludedData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseData").build()).build();

    private static final SdkField<RelatedItemEventIncludedData> RELATED_ITEM_DATA_FIELD = SdkField
            .<RelatedItemEventIncludedData> builder(MarshallingType.SDK_POJO).memberName("relatedItemData")
            .getter(getter(EventIncludedData::relatedItemData)).setter(setter(Builder::relatedItemData))
            .constructor(RelatedItemEventIncludedData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_DATA_FIELD,
            RELATED_ITEM_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CaseEventIncludedData caseData;

    private final RelatedItemEventIncludedData relatedItemData;

    private EventIncludedData(BuilderImpl builder) {
        this.caseData = builder.caseData;
        this.relatedItemData = builder.relatedItemData;
    }

    /**
     * <p>
     * Details of what case data is published through the case event stream.
     * </p>
     * 
     * @return Details of what case data is published through the case event stream.
     */
    public final CaseEventIncludedData caseData() {
        return caseData;
    }

    /**
     * <p>
     * Details of what related item data is published through the case event stream.
     * </p>
     * 
     * @return Details of what related item data is published through the case event stream.
     */
    public final RelatedItemEventIncludedData relatedItemData() {
        return relatedItemData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseData());
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventIncludedData)) {
            return false;
        }
        EventIncludedData other = (EventIncludedData) obj;
        return Objects.equals(caseData(), other.caseData()) && Objects.equals(relatedItemData(), other.relatedItemData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventIncludedData").add("CaseData", caseData()).add("RelatedItemData", relatedItemData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseData":
            return Optional.ofNullable(clazz.cast(caseData()));
        case "relatedItemData":
            return Optional.ofNullable(clazz.cast(relatedItemData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseData", CASE_DATA_FIELD);
        map.put("relatedItemData", RELATED_ITEM_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventIncludedData, T> g) {
        return obj -> g.apply((EventIncludedData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventIncludedData> {
        /**
         * <p>
         * Details of what case data is published through the case event stream.
         * </p>
         * 
         * @param caseData
         *        Details of what case data is published through the case event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseData(CaseEventIncludedData caseData);

        /**
         * <p>
         * Details of what case data is published through the case event stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaseEventIncludedData.Builder} avoiding
         * the need to create one manually via {@link CaseEventIncludedData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaseEventIncludedData.Builder#build()} is called immediately and
         * its result is passed to {@link #caseData(CaseEventIncludedData)}.
         * 
         * @param caseData
         *        a consumer that will call methods on {@link CaseEventIncludedData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caseData(CaseEventIncludedData)
         */
        default Builder caseData(Consumer<CaseEventIncludedData.Builder> caseData) {
            return caseData(CaseEventIncludedData.builder().applyMutation(caseData).build());
        }

        /**
         * <p>
         * Details of what related item data is published through the case event stream.
         * </p>
         * 
         * @param relatedItemData
         *        Details of what related item data is published through the case event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItemData(RelatedItemEventIncludedData relatedItemData);

        /**
         * <p>
         * Details of what related item data is published through the case event stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedItemEventIncludedData.Builder}
         * avoiding the need to create one manually via {@link RelatedItemEventIncludedData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedItemEventIncludedData.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedItemData(RelatedItemEventIncludedData)}.
         * 
         * @param relatedItemData
         *        a consumer that will call methods on {@link RelatedItemEventIncludedData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedItemData(RelatedItemEventIncludedData)
         */
        default Builder relatedItemData(Consumer<RelatedItemEventIncludedData.Builder> relatedItemData) {
            return relatedItemData(RelatedItemEventIncludedData.builder().applyMutation(relatedItemData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CaseEventIncludedData caseData;

        private RelatedItemEventIncludedData relatedItemData;

        private BuilderImpl() {
        }

        private BuilderImpl(EventIncludedData model) {
            caseData(model.caseData);
            relatedItemData(model.relatedItemData);
        }

        public final CaseEventIncludedData.Builder getCaseData() {
            return caseData != null ? caseData.toBuilder() : null;
        }

        public final void setCaseData(CaseEventIncludedData.BuilderImpl caseData) {
            this.caseData = caseData != null ? caseData.build() : null;
        }

        @Override
        public final Builder caseData(CaseEventIncludedData caseData) {
            this.caseData = caseData;
            return this;
        }

        public final RelatedItemEventIncludedData.Builder getRelatedItemData() {
            return relatedItemData != null ? relatedItemData.toBuilder() : null;
        }

        public final void setRelatedItemData(RelatedItemEventIncludedData.BuilderImpl relatedItemData) {
            this.relatedItemData = relatedItemData != null ? relatedItemData.build() : null;
        }

        @Override
        public final Builder relatedItemData(RelatedItemEventIncludedData relatedItemData) {
            this.relatedItemData = relatedItemData;
            return this;
        }

        @Override
        public EventIncludedData build() {
            return new EventIncludedData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
