/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCaseRuleResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<BatchGetCaseRuleResponse.Builder, BatchGetCaseRuleResponse> {
    private static final SdkField<List<GetCaseRuleResponse>> CASE_RULES_FIELD = SdkField
            .<List<GetCaseRuleResponse>> builder(MarshallingType.LIST)
            .memberName("caseRules")
            .getter(getter(BatchGetCaseRuleResponse::caseRules))
            .setter(setter(Builder::caseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetCaseRuleResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetCaseRuleResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CaseRuleError>> ERRORS_FIELD = SdkField
            .<List<CaseRuleError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetCaseRuleResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseRuleError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseRuleError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UNPROCESSED_CASE_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("unprocessedCaseRules")
            .getter(getter(BatchGetCaseRuleResponse::unprocessedCaseRules))
            .setter(setter(Builder::unprocessedCaseRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedCaseRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULES_FIELD,
            ERRORS_FIELD, UNPROCESSED_CASE_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GetCaseRuleResponse> caseRules;

    private final List<CaseRuleError> errors;

    private final List<String> unprocessedCaseRules;

    private BatchGetCaseRuleResponse(BuilderImpl builder) {
        super(builder);
        this.caseRules = builder.caseRules;
        this.errors = builder.errors;
        this.unprocessedCaseRules = builder.unprocessedCaseRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaseRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCaseRules() {
        return caseRules != null && !(caseRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of detailed case rule information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaseRules} method.
     * </p>
     * 
     * @return A list of detailed case rule information.
     */
    public final List<GetCaseRuleResponse> caseRules() {
        return caseRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of case rule errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of case rule errors.
     */
    public final List<CaseRuleError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedCaseRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedCaseRules() {
        return unprocessedCaseRules != null && !(unprocessedCaseRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unprocessed case rule identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedCaseRules} method.
     * </p>
     * 
     * @return A list of unprocessed case rule identifiers.
     */
    public final List<String> unprocessedCaseRules() {
        return unprocessedCaseRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCaseRules() ? caseRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedCaseRules() ? unprocessedCaseRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCaseRuleResponse)) {
            return false;
        }
        BatchGetCaseRuleResponse other = (BatchGetCaseRuleResponse) obj;
        return hasCaseRules() == other.hasCaseRules() && Objects.equals(caseRules(), other.caseRules())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasUnprocessedCaseRules() == other.hasUnprocessedCaseRules()
                && Objects.equals(unprocessedCaseRules(), other.unprocessedCaseRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCaseRuleResponse").add("CaseRules", hasCaseRules() ? caseRules() : null)
                .add("Errors", hasErrors() ? errors() : null)
                .add("UnprocessedCaseRules", hasUnprocessedCaseRules() ? unprocessedCaseRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseRules":
            return Optional.ofNullable(clazz.cast(caseRules()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "unprocessedCaseRules":
            return Optional.ofNullable(clazz.cast(unprocessedCaseRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseRules", CASE_RULES_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("unprocessedCaseRules", UNPROCESSED_CASE_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCaseRuleResponse, T> g) {
        return obj -> g.apply((BatchGetCaseRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCaseRuleResponse> {
        /**
         * <p>
         * A list of detailed case rule information.
         * </p>
         * 
         * @param caseRules
         *        A list of detailed case rule information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRules(Collection<GetCaseRuleResponse> caseRules);

        /**
         * <p>
         * A list of detailed case rule information.
         * </p>
         * 
         * @param caseRules
         *        A list of detailed case rule information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRules(GetCaseRuleResponse... caseRules);

        /**
         * <p>
         * A list of detailed case rule information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.GetCaseRuleResponse.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connectcases.model.GetCaseRuleResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.GetCaseRuleResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #caseRules(List<GetCaseRuleResponse>)}.
         * 
         * @param caseRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.GetCaseRuleResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caseRules(java.util.Collection<GetCaseRuleResponse>)
         */
        Builder caseRules(Consumer<GetCaseRuleResponse.Builder>... caseRules);

        /**
         * <p>
         * A list of case rule errors.
         * </p>
         * 
         * @param errors
         *        A list of case rule errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<CaseRuleError> errors);

        /**
         * <p>
         * A list of case rule errors.
         * </p>
         * 
         * @param errors
         *        A list of case rule errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(CaseRuleError... errors);

        /**
         * <p>
         * A list of case rule errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.CaseRuleError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connectcases.model.CaseRuleError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.CaseRuleError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<CaseRuleError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.CaseRuleError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<CaseRuleError>)
         */
        Builder errors(Consumer<CaseRuleError.Builder>... errors);

        /**
         * <p>
         * A list of unprocessed case rule identifiers.
         * </p>
         * 
         * @param unprocessedCaseRules
         *        A list of unprocessed case rule identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedCaseRules(Collection<String> unprocessedCaseRules);

        /**
         * <p>
         * A list of unprocessed case rule identifiers.
         * </p>
         * 
         * @param unprocessedCaseRules
         *        A list of unprocessed case rule identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedCaseRules(String... unprocessedCaseRules);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private List<GetCaseRuleResponse> caseRules = DefaultSdkAutoConstructList.getInstance();

        private List<CaseRuleError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<String> unprocessedCaseRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCaseRuleResponse model) {
            super(model);
            caseRules(model.caseRules);
            errors(model.errors);
            unprocessedCaseRules(model.unprocessedCaseRules);
        }

        public final List<GetCaseRuleResponse.Builder> getCaseRules() {
            List<GetCaseRuleResponse.Builder> result = BatchGetCaseRuleResponseCaseRulesListCopier.copyToBuilder(this.caseRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaseRules(Collection<GetCaseRuleResponse.BuilderImpl> caseRules) {
            this.caseRules = BatchGetCaseRuleResponseCaseRulesListCopier.copyFromBuilder(caseRules);
        }

        @Override
        public final Builder caseRules(Collection<GetCaseRuleResponse> caseRules) {
            this.caseRules = BatchGetCaseRuleResponseCaseRulesListCopier.copy(caseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(GetCaseRuleResponse... caseRules) {
            caseRules(Arrays.asList(caseRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(Consumer<GetCaseRuleResponse.Builder>... caseRules) {
            caseRules(Stream.of(caseRules).map(c -> GetCaseRuleResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CaseRuleError.Builder> getErrors() {
            List<CaseRuleError.Builder> result = BatchGetCaseRuleResponseErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CaseRuleError.BuilderImpl> errors) {
            this.errors = BatchGetCaseRuleResponseErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CaseRuleError> errors) {
            this.errors = BatchGetCaseRuleResponseErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CaseRuleError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CaseRuleError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> CaseRuleError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUnprocessedCaseRules() {
            if (unprocessedCaseRules instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedCaseRules;
        }

        public final void setUnprocessedCaseRules(Collection<String> unprocessedCaseRules) {
            this.unprocessedCaseRules = BatchGetCaseRuleResponseUnprocessedCaseRulesListCopier.copy(unprocessedCaseRules);
        }

        @Override
        public final Builder unprocessedCaseRules(Collection<String> unprocessedCaseRules) {
            this.unprocessedCaseRules = BatchGetCaseRuleResponseUnprocessedCaseRulesListCopier.copy(unprocessedCaseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedCaseRules(String... unprocessedCaseRules) {
            unprocessedCaseRules(Arrays.asList(unprocessedCaseRules));
            return this;
        }

        @Override
        public BatchGetCaseRuleResponse build() {
            return new BatchGetCaseRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
