/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.CaseRuleSummary;
import software.amazon.awssdk.services.connectcases.model.ListCaseRulesRequest;
import software.amazon.awssdk.services.connectcases.model.ListCaseRulesResponse;

public class ListCaseRulesPublisher
implements SdkPublisher<ListCaseRulesResponse> {
    private final ConnectCasesAsyncClient client;
    private final ListCaseRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCaseRulesPublisher(ConnectCasesAsyncClient client, ListCaseRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCaseRulesPublisher(ConnectCasesAsyncClient client, ListCaseRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCaseRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCaseRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CaseRuleSummary> caseRules() {
        Function<ListCaseRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.caseRules() != null) {
                return response.caseRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCaseRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCaseRulesResponseFetcher
    implements AsyncPageFetcher<ListCaseRulesResponse> {
        private ListCaseRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListCaseRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCaseRulesResponse> nextPage(ListCaseRulesResponse previousPage) {
            if (previousPage == null) {
                return ListCaseRulesPublisher.this.client.listCaseRules(ListCaseRulesPublisher.this.firstRequest);
            }
            return ListCaseRulesPublisher.this.client.listCaseRules((ListCaseRulesRequest)((Object)ListCaseRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

