/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.LayoutSummary;
import software.amazon.awssdk.services.connectcases.model.LayoutSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLayoutsResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, ListLayoutsResponse> {
    private static final SdkField<List<LayoutSummary>> LAYOUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layouts").getter(ListLayoutsResponse.getter(ListLayoutsResponse::layouts)).setter(ListLayoutsResponse.setter(Builder::layouts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layouts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LayoutSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLayoutsResponse.getter(ListLayoutsResponse::nextToken)).setter(ListLayoutsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLayoutsResponse.memberNameToFieldInitializer();
    private final List<LayoutSummary> layouts;
    private final String nextToken;

    private ListLayoutsResponse(BuilderImpl builder) {
        super(builder);
        this.layouts = builder.layouts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLayouts() {
        return this.layouts != null && !(this.layouts instanceof SdkAutoConstructList);
    }

    public final List<LayoutSummary> layouts() {
        return this.layouts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayouts() ? this.layouts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayoutsResponse)) {
            return false;
        }
        ListLayoutsResponse other = (ListLayoutsResponse)((Object)obj);
        return this.hasLayouts() == other.hasLayouts() && Objects.equals(this.layouts(), other.layouts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLayoutsResponse").add("Layouts", this.hasLayouts() ? this.layouts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layouts": {
                return Optional.ofNullable(clazz.cast(this.layouts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("layouts", LAYOUTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLayoutsResponse, T> g) {
        return obj -> g.apply((ListLayoutsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private List<LayoutSummary> layouts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayoutsResponse model) {
            super(model);
            this.layouts(model.layouts);
            this.nextToken(model.nextToken);
        }

        public final List<LayoutSummary.Builder> getLayouts() {
            List<LayoutSummary.Builder> result = LayoutSummaryListCopier.copyToBuilder(this.layouts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayouts(Collection<LayoutSummary.BuilderImpl> layouts) {
            this.layouts = LayoutSummaryListCopier.copyFromBuilder(layouts);
        }

        @Override
        public final Builder layouts(Collection<LayoutSummary> layouts) {
            this.layouts = LayoutSummaryListCopier.copy(layouts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layouts(LayoutSummary ... layouts) {
            this.layouts(Arrays.asList(layouts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layouts(Consumer<LayoutSummary.Builder> ... layouts) {
            this.layouts(Stream.of(layouts).map(c -> (LayoutSummary)((LayoutSummary.Builder)LayoutSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLayoutsResponse build() {
            return new ListLayoutsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLayoutsResponse> {
        public Builder layouts(Collection<LayoutSummary> var1);

        public Builder layouts(LayoutSummary ... var1);

        public Builder layouts(Consumer<LayoutSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

