/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest;
import software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse;

public class ListFieldOptionsPublisher
implements SdkPublisher<ListFieldOptionsResponse> {
    private final ConnectCasesAsyncClient client;
    private final ListFieldOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFieldOptionsPublisher(ConnectCasesAsyncClient client, ListFieldOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFieldOptionsPublisher(ConnectCasesAsyncClient client, ListFieldOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFieldOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFieldOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFieldOptionsResponseFetcher
    implements AsyncPageFetcher<ListFieldOptionsResponse> {
        private ListFieldOptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFieldOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFieldOptionsResponse> nextPage(ListFieldOptionsResponse previousPage) {
            if (previousPage == null) {
                return ListFieldOptionsPublisher.this.client.listFieldOptions(ListFieldOptionsPublisher.this.firstRequest);
            }
            return ListFieldOptionsPublisher.this.client.listFieldOptions((ListFieldOptionsRequest)((Object)ListFieldOptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

