/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.EmptyFieldValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldValueUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldValueUnion> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(FieldValueUnion.getter(FieldValueUnion::booleanValue)).setter(FieldValueUnion.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(FieldValueUnion.getter(FieldValueUnion::doubleValue)).setter(FieldValueUnion.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<EmptyFieldValue> EMPTY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("emptyValue").getter(FieldValueUnion.getter(FieldValueUnion::emptyValue)).setter(FieldValueUnion.setter(Builder::emptyValue)).constructor(EmptyFieldValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(FieldValueUnion.getter(FieldValueUnion::stringValue)).setter(FieldValueUnion.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<String> USER_ARN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArnValue").getter(FieldValueUnion.getter(FieldValueUnion::userArnValue)).setter(FieldValueUnion.setter(Builder::userArnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArnValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD, DOUBLE_VALUE_FIELD, EMPTY_VALUE_FIELD, STRING_VALUE_FIELD, USER_ARN_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("booleanValue", BOOLEAN_VALUE_FIELD);
            this.put("doubleValue", DOUBLE_VALUE_FIELD);
            this.put("emptyValue", EMPTY_VALUE_FIELD);
            this.put("stringValue", STRING_VALUE_FIELD);
            this.put("userArnValue", USER_ARN_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean booleanValue;
    private final Double doubleValue;
    private final EmptyFieldValue emptyValue;
    private final String stringValue;
    private final String userArnValue;
    private final Type type;

    private FieldValueUnion(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.emptyValue = builder.emptyValue;
        this.stringValue = builder.stringValue;
        this.userArnValue = builder.userArnValue;
        this.type = builder.type;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final EmptyFieldValue emptyValue() {
        return this.emptyValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final String userArnValue() {
        return this.userArnValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.emptyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArnValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValueUnion)) {
            return false;
        }
        FieldValueUnion other = (FieldValueUnion)obj;
        return Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.emptyValue(), other.emptyValue()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.userArnValue(), other.userArnValue());
    }

    public final String toString() {
        return ToString.builder((String)"FieldValueUnion").add("BooleanValue", (Object)this.booleanValue()).add("DoubleValue", (Object)this.doubleValue()).add("EmptyValue", (Object)this.emptyValue()).add("StringValue", (Object)this.stringValue()).add("UserArnValue", (Object)this.userArnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "emptyValue": {
                return Optional.ofNullable(clazz.cast(this.emptyValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "userArnValue": {
                return Optional.ofNullable(clazz.cast(this.userArnValue()));
            }
        }
        return Optional.empty();
    }

    public static FieldValueUnion fromBooleanValue(Boolean booleanValue) {
        return (FieldValueUnion)FieldValueUnion.builder().booleanValue(booleanValue).build();
    }

    public static FieldValueUnion fromDoubleValue(Double doubleValue) {
        return (FieldValueUnion)FieldValueUnion.builder().doubleValue(doubleValue).build();
    }

    public static FieldValueUnion fromEmptyValue(EmptyFieldValue emptyValue) {
        return (FieldValueUnion)FieldValueUnion.builder().emptyValue(emptyValue).build();
    }

    public static FieldValueUnion fromEmptyValue(Consumer<EmptyFieldValue.Builder> emptyValue) {
        EmptyFieldValue.Builder builder = EmptyFieldValue.builder();
        emptyValue.accept(builder);
        return FieldValueUnion.fromEmptyValue((EmptyFieldValue)builder.build());
    }

    public static FieldValueUnion fromStringValue(String stringValue) {
        return (FieldValueUnion)FieldValueUnion.builder().stringValue(stringValue).build();
    }

    public static FieldValueUnion fromUserArnValue(String userArnValue) {
        return (FieldValueUnion)FieldValueUnion.builder().userArnValue(userArnValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FieldValueUnion, T> g) {
        return obj -> g.apply((FieldValueUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOLEAN_VALUE,
        DOUBLE_VALUE,
        EMPTY_VALUE,
        STRING_VALUE,
        USER_ARN_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Boolean booleanValue;
        private Double doubleValue;
        private EmptyFieldValue emptyValue;
        private String stringValue;
        private String userArnValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FieldValueUnion model) {
            this.booleanValue(model.booleanValue);
            this.doubleValue(model.doubleValue);
            this.emptyValue(model.emptyValue);
            this.stringValue(model.stringValue);
            this.userArnValue(model.userArnValue);
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final EmptyFieldValue.Builder getEmptyValue() {
            return this.emptyValue != null ? this.emptyValue.toBuilder() : null;
        }

        public final void setEmptyValue(EmptyFieldValue.BuilderImpl emptyValue) {
            EmptyFieldValue oldValue = this.emptyValue;
            this.emptyValue = emptyValue != null ? emptyValue.build() : null;
            this.handleUnionValueChange(Type.EMPTY_VALUE, oldValue, this.emptyValue);
        }

        @Override
        public final Builder emptyValue(EmptyFieldValue emptyValue) {
            EmptyFieldValue oldValue = this.emptyValue;
            this.emptyValue = emptyValue;
            this.handleUnionValueChange(Type.EMPTY_VALUE, oldValue, this.emptyValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final String getUserArnValue() {
            return this.userArnValue;
        }

        public final void setUserArnValue(String userArnValue) {
            String oldValue = this.userArnValue;
            this.userArnValue = userArnValue;
            this.handleUnionValueChange(Type.USER_ARN_VALUE, oldValue, this.userArnValue);
        }

        @Override
        public final Builder userArnValue(String userArnValue) {
            String oldValue = this.userArnValue;
            this.userArnValue = userArnValue;
            this.handleUnionValueChange(Type.USER_ARN_VALUE, oldValue, this.userArnValue);
            return this;
        }

        public FieldValueUnion build() {
            return new FieldValueUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldValueUnion> {
        public Builder booleanValue(Boolean var1);

        public Builder doubleValue(Double var1);

        public Builder emptyValue(EmptyFieldValue var1);

        default public Builder emptyValue(Consumer<EmptyFieldValue.Builder> emptyValue) {
            return this.emptyValue((EmptyFieldValue)((EmptyFieldValue.Builder)EmptyFieldValue.builder().applyMutation(emptyValue)).build());
        }

        public Builder stringValue(String var1);

        public Builder userArnValue(String var1);
    }
}

