/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration to enable EventBridge case event delivery and determine what data is delivered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventBridgeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EventBridgeConfiguration.Builder, EventBridgeConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(EventBridgeConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<EventIncludedData> INCLUDED_DATA_FIELD = SdkField
            .<EventIncludedData> builder(MarshallingType.SDK_POJO).memberName("includedData")
            .getter(getter(EventBridgeConfiguration::includedData)).setter(setter(Builder::includedData))
            .constructor(EventIncludedData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            INCLUDED_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final EventIncludedData includedData;

    private EventBridgeConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.includedData = builder.includedData;
    }

    /**
     * <p>
     * Indicates whether the to broadcast case event data to the customer.
     * </p>
     * 
     * @return Indicates whether the to broadcast case event data to the customer.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Details of what case and related item data is published through the case event stream.
     * </p>
     * 
     * @return Details of what case and related item data is published through the case event stream.
     */
    public final EventIncludedData includedData() {
        return includedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(includedData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventBridgeConfiguration)) {
            return false;
        }
        EventBridgeConfiguration other = (EventBridgeConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(includedData(), other.includedData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventBridgeConfiguration").add("Enabled", enabled()).add("IncludedData", includedData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "includedData":
            return Optional.ofNullable(clazz.cast(includedData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventBridgeConfiguration, T> g) {
        return obj -> g.apply((EventBridgeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventBridgeConfiguration> {
        /**
         * <p>
         * Indicates whether the to broadcast case event data to the customer.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the to broadcast case event data to the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Details of what case and related item data is published through the case event stream.
         * </p>
         * 
         * @param includedData
         *        Details of what case and related item data is published through the case event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedData(EventIncludedData includedData);

        /**
         * <p>
         * Details of what case and related item data is published through the case event stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventIncludedData.Builder} avoiding the
         * need to create one manually via {@link EventIncludedData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventIncludedData.Builder#build()} is called immediately and its
         * result is passed to {@link #includedData(EventIncludedData)}.
         * 
         * @param includedData
         *        a consumer that will call methods on {@link EventIncludedData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includedData(EventIncludedData)
         */
        default Builder includedData(Consumer<EventIncludedData.Builder> includedData) {
            return includedData(EventIncludedData.builder().applyMutation(includedData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private EventIncludedData includedData;

        private BuilderImpl() {
        }

        private BuilderImpl(EventBridgeConfiguration model) {
            enabled(model.enabled);
            includedData(model.includedData);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final EventIncludedData.Builder getIncludedData() {
            return includedData != null ? includedData.toBuilder() : null;
        }

        public final void setIncludedData(EventIncludedData.BuilderImpl includedData) {
            this.includedData = includedData != null ? includedData.build() : null;
        }

        @Override
        public final Builder includedData(EventIncludedData includedData) {
            this.includedData = includedData;
            return this;
        }

        @Override
        public EventBridgeConfiguration build() {
            return new EventBridgeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
