/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<GetDomainResponse.Builder, GetDomainResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(GetDomainResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainArn").getter(getter(GetDomainResponse::domainArn)).setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetDomainResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainStatus").getter(getter(GetDomainResponse::domainStatusAsString))
            .setter(setter(Builder::domainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainStatus").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetDomainResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetDomainResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            DOMAIN_ARN_FIELD, DOMAIN_ID_FIELD, DOMAIN_STATUS_FIELD, NAME_FIELD, TAGS_FIELD));

    private final Instant createdTime;

    private final String domainArn;

    private final String domainId;

    private final String domainStatus;

    private final String name;

    private final Map<String, String> tags;

    private GetDomainResponse(BuilderImpl builder) {
        super(builder);
        this.createdTime = builder.createdTime;
        this.domainArn = builder.domainArn;
        this.domainId = builder.domainId;
        this.domainStatus = builder.domainStatus;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The timestamp when the Cases domain was created.
     * </p>
     * 
     * @return The timestamp when the Cases domain was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Cases domain.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Cases domain.
     */
    public final String domainArn() {
        return domainArn;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The status of the Cases domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainStatus} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStatusAsString}.
     * </p>
     * 
     * @return The status of the Cases domain.
     * @see DomainStatus
     */
    public final DomainStatus domainStatus() {
        return DomainStatus.fromValue(domainStatus);
    }

    /**
     * <p>
     * The status of the Cases domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainStatus} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStatusAsString}.
     * </p>
     * 
     * @return The status of the Cases domain.
     * @see DomainStatus
     */
    public final String domainStatusAsString() {
        return domainStatus;
    }

    /**
     * <p>
     * The name of the Cases domain.
     * </p>
     * 
     * @return The name of the Cases domain.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
     * access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
     *         control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainResponse)) {
            return false;
        }
        GetDomainResponse other = (GetDomainResponse) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(domainArn(), other.domainArn())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(domainStatusAsString(), other.domainStatusAsString()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDomainResponse").add("CreatedTime", createdTime()).add("DomainArn", domainArn())
                .add("DomainId", domainId()).add("DomainStatus", domainStatusAsString()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "domainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "domainStatus":
            return Optional.ofNullable(clazz.cast(domainStatusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainResponse, T> g) {
        return obj -> g.apply((GetDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDomainResponse> {
        /**
         * <p>
         * The timestamp when the Cases domain was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the Cases domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Cases domain.
         * </p>
         * 
         * @param domainArn
         *        The Amazon Resource Name (ARN) for the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The status of the Cases domain.
         * </p>
         * 
         * @param domainStatus
         *        The status of the Cases domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder domainStatus(String domainStatus);

        /**
         * <p>
         * The status of the Cases domain.
         * </p>
         * 
         * @param domainStatus
         *        The status of the Cases domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder domainStatus(DomainStatus domainStatus);

        /**
         * <p>
         * The name of the Cases domain.
         * </p>
         * 
         * @param name
         *        The name of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
         * access for this resource.
         * </p>
         * 
         * @param tags
         *        A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
         *        control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private Instant createdTime;

        private String domainArn;

        private String domainId;

        private String domainStatus;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainResponse model) {
            super(model);
            createdTime(model.createdTime);
            domainArn(model.domainArn);
            domainId(model.domainId);
            domainStatus(model.domainStatus);
            name(model.name);
            tags(model.tags);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDomainArn() {
            return domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainStatus() {
            return domainStatus;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetDomainResponse build() {
            return new GetDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
