/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Content specific to <code>BasicLayout</code> type. It configures fields in the top panel and More Info tab of agent
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BasicLayout implements SdkPojo, Serializable, ToCopyableBuilder<BasicLayout.Builder, BasicLayout> {
    private static final SdkField<LayoutSections> MORE_INFO_FIELD = SdkField.<LayoutSections> builder(MarshallingType.SDK_POJO)
            .memberName("moreInfo").getter(getter(BasicLayout::moreInfo)).setter(setter(Builder::moreInfo))
            .constructor(LayoutSections::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moreInfo").build()).build();

    private static final SdkField<LayoutSections> TOP_PANEL_FIELD = SdkField.<LayoutSections> builder(MarshallingType.SDK_POJO)
            .memberName("topPanel").getter(getter(BasicLayout::topPanel)).setter(setter(Builder::topPanel))
            .constructor(LayoutSections::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topPanel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MORE_INFO_FIELD,
            TOP_PANEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final LayoutSections moreInfo;

    private final LayoutSections topPanel;

    private BasicLayout(BuilderImpl builder) {
        this.moreInfo = builder.moreInfo;
        this.topPanel = builder.topPanel;
    }

    /**
     * <p>
     * This represents sections in a tab of the page layout.
     * </p>
     * 
     * @return This represents sections in a tab of the page layout.
     */
    public final LayoutSections moreInfo() {
        return moreInfo;
    }

    /**
     * <p>
     * This represents sections in a panel of the page layout.
     * </p>
     * 
     * @return This represents sections in a panel of the page layout.
     */
    public final LayoutSections topPanel() {
        return topPanel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moreInfo());
        hashCode = 31 * hashCode + Objects.hashCode(topPanel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicLayout)) {
            return false;
        }
        BasicLayout other = (BasicLayout) obj;
        return Objects.equals(moreInfo(), other.moreInfo()) && Objects.equals(topPanel(), other.topPanel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BasicLayout").add("MoreInfo", moreInfo()).add("TopPanel", topPanel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "moreInfo":
            return Optional.ofNullable(clazz.cast(moreInfo()));
        case "topPanel":
            return Optional.ofNullable(clazz.cast(topPanel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BasicLayout, T> g) {
        return obj -> g.apply((BasicLayout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BasicLayout> {
        /**
         * <p>
         * This represents sections in a tab of the page layout.
         * </p>
         * 
         * @param moreInfo
         *        This represents sections in a tab of the page layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moreInfo(LayoutSections moreInfo);

        /**
         * <p>
         * This represents sections in a tab of the page layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutSections.Builder} avoiding the need
         * to create one manually via {@link LayoutSections#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutSections.Builder#build()} is called immediately and its
         * result is passed to {@link #moreInfo(LayoutSections)}.
         * 
         * @param moreInfo
         *        a consumer that will call methods on {@link LayoutSections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moreInfo(LayoutSections)
         */
        default Builder moreInfo(Consumer<LayoutSections.Builder> moreInfo) {
            return moreInfo(LayoutSections.builder().applyMutation(moreInfo).build());
        }

        /**
         * <p>
         * This represents sections in a panel of the page layout.
         * </p>
         * 
         * @param topPanel
         *        This represents sections in a panel of the page layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topPanel(LayoutSections topPanel);

        /**
         * <p>
         * This represents sections in a panel of the page layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutSections.Builder} avoiding the need
         * to create one manually via {@link LayoutSections#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutSections.Builder#build()} is called immediately and its
         * result is passed to {@link #topPanel(LayoutSections)}.
         * 
         * @param topPanel
         *        a consumer that will call methods on {@link LayoutSections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topPanel(LayoutSections)
         */
        default Builder topPanel(Consumer<LayoutSections.Builder> topPanel) {
            return topPanel(LayoutSections.builder().applyMutation(topPanel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LayoutSections moreInfo;

        private LayoutSections topPanel;

        private BuilderImpl() {
        }

        private BuilderImpl(BasicLayout model) {
            moreInfo(model.moreInfo);
            topPanel(model.topPanel);
        }

        public final LayoutSections.Builder getMoreInfo() {
            return moreInfo != null ? moreInfo.toBuilder() : null;
        }

        public final void setMoreInfo(LayoutSections.BuilderImpl moreInfo) {
            this.moreInfo = moreInfo != null ? moreInfo.build() : null;
        }

        @Override
        public final Builder moreInfo(LayoutSections moreInfo) {
            this.moreInfo = moreInfo;
            return this;
        }

        public final LayoutSections.Builder getTopPanel() {
            return topPanel != null ? topPanel.toBuilder() : null;
        }

        public final void setTopPanel(LayoutSections.BuilderImpl topPanel) {
            this.topPanel = topPanel != null ? topPanel.build() : null;
        }

        @Override
        public final Builder topPanel(LayoutSections topPanel) {
            this.topPanel = topPanel;
            return this;
        }

        @Override
        public BasicLayout build() {
            return new BasicLayout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
