/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationLimitTimeUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommunicationLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommunicationLimit> {
    private static final SdkField<Integer> MAX_COUNT_PER_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCountPerRecipient").getter(CommunicationLimit.getter(CommunicationLimit::maxCountPerRecipient)).setter(CommunicationLimit.setter(Builder::maxCountPerRecipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCountPerRecipient").build()}).build();
    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("frequency").getter(CommunicationLimit.getter(CommunicationLimit::frequency)).setter(CommunicationLimit.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(CommunicationLimit.getter(CommunicationLimit::unitAsString)).setter(CommunicationLimit.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_COUNT_PER_RECIPIENT_FIELD, FREQUENCY_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maxCountPerRecipient", MAX_COUNT_PER_RECIPIENT_FIELD);
            this.put("frequency", FREQUENCY_FIELD);
            this.put("unit", UNIT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer maxCountPerRecipient;
    private final Integer frequency;
    private final String unit;

    private CommunicationLimit(BuilderImpl builder) {
        this.maxCountPerRecipient = builder.maxCountPerRecipient;
        this.frequency = builder.frequency;
        this.unit = builder.unit;
    }

    public final Integer maxCountPerRecipient() {
        return this.maxCountPerRecipient;
    }

    public final Integer frequency() {
        return this.frequency;
    }

    public final CommunicationLimitTimeUnit unit() {
        return CommunicationLimitTimeUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCountPerRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommunicationLimit)) {
            return false;
        }
        CommunicationLimit other = (CommunicationLimit)obj;
        return Objects.equals(this.maxCountPerRecipient(), other.maxCountPerRecipient()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CommunicationLimit").add("MaxCountPerRecipient", (Object)this.maxCountPerRecipient()).add("Frequency", (Object)this.frequency()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxCountPerRecipient": {
                return Optional.ofNullable(clazz.cast(this.maxCountPerRecipient()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CommunicationLimit, T> g) {
        return obj -> g.apply((CommunicationLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxCountPerRecipient;
        private Integer frequency;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(CommunicationLimit model) {
            this.maxCountPerRecipient(model.maxCountPerRecipient);
            this.frequency(model.frequency);
            this.unit(model.unit);
        }

        public final Integer getMaxCountPerRecipient() {
            return this.maxCountPerRecipient;
        }

        public final void setMaxCountPerRecipient(Integer maxCountPerRecipient) {
            this.maxCountPerRecipient = maxCountPerRecipient;
        }

        @Override
        public final Builder maxCountPerRecipient(Integer maxCountPerRecipient) {
            this.maxCountPerRecipient = maxCountPerRecipient;
            return this;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(CommunicationLimitTimeUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public CommunicationLimit build() {
            return new CommunicationLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommunicationLimit> {
        public Builder maxCountPerRecipient(Integer var1);

        public Builder frequency(Integer var1);

        public Builder unit(String var1);

        public Builder unit(CommunicationLimitTimeUnit var1);
    }
}

