/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.connectcampaigns.ConnectCampaignsClient;
import software.amazon.awssdk.services.connectcampaigns.ConnectCampaignsClientBuilder;
import software.amazon.awssdk.services.connectcampaigns.ConnectCampaignsServiceClientConfiguration;
import software.amazon.awssdk.services.connectcampaigns.DefaultConnectCampaignsBaseClientBuilder;
import software.amazon.awssdk.services.connectcampaigns.DefaultConnectCampaignsClient;
import software.amazon.awssdk.services.connectcampaigns.endpoints.ConnectCampaignsEndpointProvider;

@SdkInternalApi
final class DefaultConnectCampaignsClientBuilder
extends DefaultConnectCampaignsBaseClientBuilder<ConnectCampaignsClientBuilder, ConnectCampaignsClient>
implements ConnectCampaignsClientBuilder {
    DefaultConnectCampaignsClientBuilder() {
    }

    @Override
    public DefaultConnectCampaignsClientBuilder endpointProvider(ConnectCampaignsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ConnectCampaignsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultConnectCampaignsClientBuilder.validateClientOptions(clientConfiguration);
        ConnectCampaignsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultConnectCampaignsClient client = new DefaultConnectCampaignsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ConnectCampaignsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ConnectCampaignsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

