/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesResponse;
import software.amazon.awssdk.services.connect.model.WorkspacePage;

public class ListWorkspacePagesPublisher
implements SdkPublisher<ListWorkspacePagesResponse> {
    private final ConnectAsyncClient client;
    private final ListWorkspacePagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkspacePagesPublisher(ConnectAsyncClient client, ListWorkspacePagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkspacePagesPublisher(ConnectAsyncClient client, ListWorkspacePagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkspacePagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkspacePagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspacePage> workspacePageList() {
        Function<ListWorkspacePagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspacePageList() != null) {
                return response.workspacePageList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkspacePagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkspacePagesResponseFetcher
    implements AsyncPageFetcher<ListWorkspacePagesResponse> {
        private ListWorkspacePagesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspacePagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkspacePagesResponse> nextPage(ListWorkspacePagesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspacePagesPublisher.this.client.listWorkspacePages(ListWorkspacePagesPublisher.this.firstRequest);
            }
            return ListWorkspacePagesPublisher.this.client.listWorkspacePages((ListWorkspacePagesRequest)((Object)ListWorkspacePagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

