/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesResponse;
import software.amazon.awssdk.services.connect.model.RecordPrimaryValue;

public class ListDataTablePrimaryValuesPublisher
implements SdkPublisher<ListDataTablePrimaryValuesResponse> {
    private final ConnectAsyncClient client;
    private final ListDataTablePrimaryValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataTablePrimaryValuesPublisher(ConnectAsyncClient client, ListDataTablePrimaryValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataTablePrimaryValuesPublisher(ConnectAsyncClient client, ListDataTablePrimaryValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataTablePrimaryValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataTablePrimaryValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecordPrimaryValue> primaryValuesList() {
        Function<ListDataTablePrimaryValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.primaryValuesList() != null) {
                return response.primaryValuesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataTablePrimaryValuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataTablePrimaryValuesResponseFetcher
    implements AsyncPageFetcher<ListDataTablePrimaryValuesResponse> {
        private ListDataTablePrimaryValuesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataTablePrimaryValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataTablePrimaryValuesResponse> nextPage(ListDataTablePrimaryValuesResponse previousPage) {
            if (previousPage == null) {
                return ListDataTablePrimaryValuesPublisher.this.client.listDataTablePrimaryValues(ListDataTablePrimaryValuesPublisher.this.firstRequest);
            }
            return ListDataTablePrimaryValuesPublisher.this.client.listDataTablePrimaryValues((ListDataTablePrimaryValuesRequest)((Object)ListDataTablePrimaryValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

