/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleAliasSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesResponse;

public class ListContactFlowModuleAliasesPublisher
implements SdkPublisher<ListContactFlowModuleAliasesResponse> {
    private final ConnectAsyncClient client;
    private final ListContactFlowModuleAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactFlowModuleAliasesPublisher(ConnectAsyncClient client, ListContactFlowModuleAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactFlowModuleAliasesPublisher(ConnectAsyncClient client, ListContactFlowModuleAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactFlowModuleAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactFlowModuleAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList() {
        Function<ListContactFlowModuleAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModuleAliasSummaryList() != null) {
                return response.contactFlowModuleAliasSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactFlowModuleAliasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactFlowModuleAliasesResponseFetcher
    implements AsyncPageFetcher<ListContactFlowModuleAliasesResponse> {
        private ListContactFlowModuleAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowModuleAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactFlowModuleAliasesResponse> nextPage(ListContactFlowModuleAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowModuleAliasesPublisher.this.client.listContactFlowModuleAliases(ListContactFlowModuleAliasesPublisher.this.firstRequest);
            }
            return ListContactFlowModuleAliasesPublisher.this.client.listContactFlowModuleAliases((ListContactFlowModuleAliasesRequest)((Object)ListContactFlowModuleAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

