/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkspaceFontFamily {
    ARIAL("Arial"),
    COURIER_NEW("Courier New"),
    GEORGIA("Georgia"),
    TIMES_NEW_ROMAN("Times New Roman"),
    TREBUCHET("Trebuchet"),
    VERDANA("Verdana"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspaceFontFamily> VALUE_MAP;
    private final String value;

    private WorkspaceFontFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspaceFontFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspaceFontFamily> knownValues() {
        EnumSet<WorkspaceFontFamily> knownValues = EnumSet.allOf(WorkspaceFontFamily.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkspaceFontFamily.class, WorkspaceFontFamily::toString);
    }
}

