/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.WorkspaceTheme;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceThemeRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceThemeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateWorkspaceThemeRequest.getter(UpdateWorkspaceThemeRequest::instanceId)).setter(UpdateWorkspaceThemeRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(UpdateWorkspaceThemeRequest.getter(UpdateWorkspaceThemeRequest::workspaceId)).setter(UpdateWorkspaceThemeRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkspaceId").build()}).build();
    private static final SdkField<WorkspaceTheme> THEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Theme").getter(UpdateWorkspaceThemeRequest.getter(UpdateWorkspaceThemeRequest::theme)).setter(UpdateWorkspaceThemeRequest.setter(Builder::theme)).constructor(WorkspaceTheme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Theme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, WORKSPACE_ID_FIELD, THEME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkspaceThemeRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String workspaceId;
    private final WorkspaceTheme theme;

    private UpdateWorkspaceThemeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.workspaceId = builder.workspaceId;
        this.theme = builder.theme;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final WorkspaceTheme theme() {
        return this.theme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.theme());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceThemeRequest)) {
            return false;
        }
        UpdateWorkspaceThemeRequest other = (UpdateWorkspaceThemeRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.theme(), other.theme());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceThemeRequest").add("InstanceId", (Object)this.instanceId()).add("WorkspaceId", (Object)this.workspaceId()).add("Theme", (Object)this.theme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "Theme": {
                return Optional.ofNullable(clazz.cast(this.theme()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("Theme", THEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceThemeRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceThemeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String workspaceId;
        private WorkspaceTheme theme;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceThemeRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.workspaceId(model.workspaceId);
            this.theme(model.theme);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final WorkspaceTheme.Builder getTheme() {
            return this.theme != null ? this.theme.toBuilder() : null;
        }

        public final void setTheme(WorkspaceTheme.BuilderImpl theme) {
            this.theme = theme != null ? theme.build() : null;
        }

        @Override
        public final Builder theme(WorkspaceTheme theme) {
            this.theme = theme;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceThemeRequest build() {
            return new UpdateWorkspaceThemeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceThemeRequest> {
        public Builder instanceId(String var1);

        public Builder workspaceId(String var1);

        public Builder theme(WorkspaceTheme var1);

        default public Builder theme(Consumer<WorkspaceTheme.Builder> theme) {
            return this.theme((WorkspaceTheme)((WorkspaceTheme.Builder)WorkspaceTheme.builder().applyMutation(theme)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

