/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.DataTableLockVersion;
import software.amazon.awssdk.services.connect.model.PrimaryValue;
import software.amazon.awssdk.services.connect.model.PrimaryValuesSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataTablePrimaryValuesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateDataTablePrimaryValuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateDataTablePrimaryValuesRequest.getter(UpdateDataTablePrimaryValuesRequest::instanceId)).setter(UpdateDataTablePrimaryValuesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableId").getter(UpdateDataTablePrimaryValuesRequest.getter(UpdateDataTablePrimaryValuesRequest::dataTableId)).setter(UpdateDataTablePrimaryValuesRequest.setter(Builder::dataTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()}).build();
    private static final SdkField<List<PrimaryValue>> PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryValues").getter(UpdateDataTablePrimaryValuesRequest.getter(UpdateDataTablePrimaryValuesRequest::primaryValues)).setter(UpdateDataTablePrimaryValuesRequest.setter(Builder::primaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrimaryValue>> NEW_PRIMARY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewPrimaryValues").getter(UpdateDataTablePrimaryValuesRequest.getter(UpdateDataTablePrimaryValuesRequest::newPrimaryValues)).setter(UpdateDataTablePrimaryValuesRequest.setter(Builder::newPrimaryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPrimaryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockVersion").getter(UpdateDataTablePrimaryValuesRequest.getter(UpdateDataTablePrimaryValuesRequest::lockVersion)).setter(UpdateDataTablePrimaryValuesRequest.setter(Builder::lockVersion)).constructor(DataTableLockVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DATA_TABLE_ID_FIELD, PRIMARY_VALUES_FIELD, NEW_PRIMARY_VALUES_FIELD, LOCK_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataTablePrimaryValuesRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String dataTableId;
    private final List<PrimaryValue> primaryValues;
    private final List<PrimaryValue> newPrimaryValues;
    private final DataTableLockVersion lockVersion;

    private UpdateDataTablePrimaryValuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.primaryValues = builder.primaryValues;
        this.newPrimaryValues = builder.newPrimaryValues;
        this.lockVersion = builder.lockVersion;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String dataTableId() {
        return this.dataTableId;
    }

    public final boolean hasPrimaryValues() {
        return this.primaryValues != null && !(this.primaryValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryValue> primaryValues() {
        return this.primaryValues;
    }

    public final boolean hasNewPrimaryValues() {
        return this.newPrimaryValues != null && !(this.newPrimaryValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryValue> newPrimaryValues() {
        return this.newPrimaryValues;
    }

    public final DataTableLockVersion lockVersion() {
        return this.lockVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryValues() ? this.primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewPrimaryValues() ? this.newPrimaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lockVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataTablePrimaryValuesRequest)) {
            return false;
        }
        UpdateDataTablePrimaryValuesRequest other = (UpdateDataTablePrimaryValuesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.dataTableId(), other.dataTableId()) && this.hasPrimaryValues() == other.hasPrimaryValues() && Objects.equals(this.primaryValues(), other.primaryValues()) && this.hasNewPrimaryValues() == other.hasNewPrimaryValues() && Objects.equals(this.newPrimaryValues(), other.newPrimaryValues()) && Objects.equals(this.lockVersion(), other.lockVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataTablePrimaryValuesRequest").add("InstanceId", (Object)this.instanceId()).add("DataTableId", (Object)this.dataTableId()).add("PrimaryValues", this.hasPrimaryValues() ? this.primaryValues() : null).add("NewPrimaryValues", this.hasNewPrimaryValues() ? this.newPrimaryValues() : null).add("LockVersion", (Object)this.lockVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DataTableId": {
                return Optional.ofNullable(clazz.cast(this.dataTableId()));
            }
            case "PrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.primaryValues()));
            }
            case "NewPrimaryValues": {
                return Optional.ofNullable(clazz.cast(this.newPrimaryValues()));
            }
            case "LockVersion": {
                return Optional.ofNullable(clazz.cast(this.lockVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("NewPrimaryValues", NEW_PRIMARY_VALUES_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataTablePrimaryValuesRequest, T> g) {
        return obj -> g.apply((UpdateDataTablePrimaryValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String dataTableId;
        private List<PrimaryValue> primaryValues = DefaultSdkAutoConstructList.getInstance();
        private List<PrimaryValue> newPrimaryValues = DefaultSdkAutoConstructList.getInstance();
        private DataTableLockVersion lockVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataTablePrimaryValuesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.dataTableId(model.dataTableId);
            this.primaryValues(model.primaryValues);
            this.newPrimaryValues(model.newPrimaryValues);
            this.lockVersion(model.lockVersion);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return this.dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final List<PrimaryValue.Builder> getPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValue.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValue> primaryValues) {
            this.primaryValues = PrimaryValuesSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValue ... primaryValues) {
            this.primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValue.Builder> ... primaryValues) {
            this.primaryValues(Stream.of(primaryValues).map(c -> (PrimaryValue)((PrimaryValue.Builder)PrimaryValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PrimaryValue.Builder> getNewPrimaryValues() {
            List<PrimaryValue.Builder> result = PrimaryValuesSetCopier.copyToBuilder(this.newPrimaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNewPrimaryValues(Collection<PrimaryValue.BuilderImpl> newPrimaryValues) {
            this.newPrimaryValues = PrimaryValuesSetCopier.copyFromBuilder(newPrimaryValues);
        }

        @Override
        public final Builder newPrimaryValues(Collection<PrimaryValue> newPrimaryValues) {
            this.newPrimaryValues = PrimaryValuesSetCopier.copy(newPrimaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newPrimaryValues(PrimaryValue ... newPrimaryValues) {
            this.newPrimaryValues(Arrays.asList(newPrimaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newPrimaryValues(Consumer<PrimaryValue.Builder> ... newPrimaryValues) {
            this.newPrimaryValues(Stream.of(newPrimaryValues).map(c -> (PrimaryValue)((PrimaryValue.Builder)PrimaryValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return this.lockVersion != null ? this.lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataTablePrimaryValuesRequest build() {
            return new UpdateDataTablePrimaryValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataTablePrimaryValuesRequest> {
        public Builder instanceId(String var1);

        public Builder dataTableId(String var1);

        public Builder primaryValues(Collection<PrimaryValue> var1);

        public Builder primaryValues(PrimaryValue ... var1);

        public Builder primaryValues(Consumer<PrimaryValue.Builder> ... var1);

        public Builder newPrimaryValues(Collection<PrimaryValue> var1);

        public Builder newPrimaryValues(PrimaryValue ... var1);

        public Builder newPrimaryValues(Consumer<PrimaryValue.Builder> ... var1);

        public Builder lockVersion(DataTableLockVersion var1);

        default public Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return this.lockVersion((DataTableLockVersion)((DataTableLockVersion.Builder)DataTableLockVersion.builder().applyMutation(lockVersion)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

