/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.MediaItem;
import software.amazon.awssdk.services.connect.model.MediaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspaceMediaResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListWorkspaceMediaResponse> {
    private static final SdkField<List<MediaItem>> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Media").getter(ListWorkspaceMediaResponse.getter(ListWorkspaceMediaResponse::media)).setter(ListWorkspaceMediaResponse.setter(Builder::media)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkspaceMediaResponse.memberNameToFieldInitializer();
    private final List<MediaItem> media;

    private ListWorkspaceMediaResponse(BuilderImpl builder) {
        super(builder);
        this.media = builder.media;
    }

    public final boolean hasMedia() {
        return this.media != null && !(this.media instanceof SdkAutoConstructList);
    }

    public final List<MediaItem> media() {
        return this.media;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMedia() ? this.media() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceMediaResponse)) {
            return false;
        }
        ListWorkspaceMediaResponse other = (ListWorkspaceMediaResponse)((Object)obj);
        return this.hasMedia() == other.hasMedia() && Objects.equals(this.media(), other.media());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspaceMediaResponse").add("Media", this.hasMedia() ? this.media() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<MediaItem>>> map = new HashMap<String, SdkField<List<MediaItem>>>();
        map.put("Media", MEDIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceMediaResponse, T> g) {
        return obj -> g.apply((ListWorkspaceMediaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<MediaItem> media = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceMediaResponse model) {
            super(model);
            this.media(model.media);
        }

        public final List<MediaItem.Builder> getMedia() {
            List<MediaItem.Builder> result = MediaListCopier.copyToBuilder(this.media);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMedia(Collection<MediaItem.BuilderImpl> media) {
            this.media = MediaListCopier.copyFromBuilder(media);
        }

        @Override
        public final Builder media(Collection<MediaItem> media) {
            this.media = MediaListCopier.copy(media);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder media(MediaItem ... media) {
            this.media(Arrays.asList(media));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder media(Consumer<MediaItem.Builder> ... media) {
            this.media(Stream.of(media).map(c -> (MediaItem)((MediaItem.Builder)MediaItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspaceMediaResponse build() {
            return new ListWorkspaceMediaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspaceMediaResponse> {
        public Builder media(Collection<MediaItem> var1);

        public Builder media(MediaItem ... var1);

        public Builder media(Consumer<MediaItem.Builder> ... var1);
    }
}

