/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentStatusesCopier;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ChannelsCopier;
import software.amazon.awssdk.services.connect.model.QueuesCopier;
import software.amazon.awssdk.services.connect.model.RoutingExpressionsCopier;
import software.amazon.awssdk.services.connect.model.RoutingProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(Filters.getter(Filters::queues)).setter(Filters.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(Filters.getter(Filters::channelsAsStrings)).setter(Filters.setter(Builder::channelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROUTING_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingProfiles").getter(Filters.getter(Filters::routingProfiles)).setter(Filters.setter(Builder::routingProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ROUTING_STEP_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingStepExpressions").getter(Filters.getter(Filters::routingStepExpressions)).setter(Filters.setter(Builder::routingStepExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStepExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AGENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentStatuses").getter(Filters.getter(Filters::agentStatuses)).setter(Filters.setter(Builder::agentStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, CHANNELS_FIELD, ROUTING_PROFILES_FIELD, ROUTING_STEP_EXPRESSIONS_FIELD, AGENT_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Filters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> queues;
    private final List<String> channels;
    private final List<String> routingProfiles;
    private final List<String> routingStepExpressions;
    private final List<String> agentStatuses;

    private Filters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.channels = builder.channels;
        this.routingProfiles = builder.routingProfiles;
        this.routingStepExpressions = builder.routingStepExpressions;
        this.agentStatuses = builder.agentStatuses;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<String> queues() {
        return this.queues;
    }

    public final List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(this.channels);
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channelsAsStrings() {
        return this.channels;
    }

    public final boolean hasRoutingProfiles() {
        return this.routingProfiles != null && !(this.routingProfiles instanceof SdkAutoConstructList);
    }

    public final List<String> routingProfiles() {
        return this.routingProfiles;
    }

    public final boolean hasRoutingStepExpressions() {
        return this.routingStepExpressions != null && !(this.routingStepExpressions instanceof SdkAutoConstructList);
    }

    public final List<String> routingStepExpressions() {
        return this.routingStepExpressions;
    }

    public final boolean hasAgentStatuses() {
        return this.agentStatuses != null && !(this.agentStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> agentStatuses() {
        return this.agentStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingProfiles() ? this.routingProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingStepExpressions() ? this.routingStepExpressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentStatuses() ? this.agentStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && this.hasChannels() == other.hasChannels() && Objects.equals(this.channelsAsStrings(), other.channelsAsStrings()) && this.hasRoutingProfiles() == other.hasRoutingProfiles() && Objects.equals(this.routingProfiles(), other.routingProfiles()) && this.hasRoutingStepExpressions() == other.hasRoutingStepExpressions() && Objects.equals(this.routingStepExpressions(), other.routingStepExpressions()) && this.hasAgentStatuses() == other.hasAgentStatuses() && Objects.equals(this.agentStatuses(), other.agentStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"Filters").add("Queues", this.hasQueues() ? this.queues() : null).add("Channels", this.hasChannels() ? this.channelsAsStrings() : null).add("RoutingProfiles", this.hasRoutingProfiles() ? this.routingProfiles() : null).add("RoutingStepExpressions", this.hasRoutingStepExpressions() ? this.routingStepExpressions() : null).add("AgentStatuses", this.hasAgentStatuses() ? this.agentStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channelsAsStrings()));
            }
            case "RoutingProfiles": {
                return Optional.ofNullable(clazz.cast(this.routingProfiles()));
            }
            case "RoutingStepExpressions": {
                return Optional.ofNullable(clazz.cast(this.routingStepExpressions()));
            }
            case "AgentStatuses": {
                return Optional.ofNullable(clazz.cast(this.agentStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Queues", QUEUES_FIELD);
        map.put("Channels", CHANNELS_FIELD);
        map.put("RoutingProfiles", ROUTING_PROFILES_FIELD);
        map.put("RoutingStepExpressions", ROUTING_STEP_EXPRESSIONS_FIELD);
        map.put("AgentStatuses", AGENT_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private List<String> routingProfiles = DefaultSdkAutoConstructList.getInstance();
        private List<String> routingStepExpressions = DefaultSdkAutoConstructList.getInstance();
        private List<String> agentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            this.queues(model.queues);
            this.channelsWithStrings(model.channels);
            this.routingProfiles(model.routingProfiles);
            this.routingStepExpressions(model.routingStepExpressions);
            this.agentStatuses(model.agentStatuses);
        }

        public final Collection<String> getQueues() {
            if (this.queues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String ... channels) {
            this.channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final Collection<String> getRoutingProfiles() {
            if (this.routingProfiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routingProfiles;
        }

        public final void setRoutingProfiles(Collection<String> routingProfiles) {
            this.routingProfiles = RoutingProfilesCopier.copy(routingProfiles);
        }

        @Override
        public final Builder routingProfiles(Collection<String> routingProfiles) {
            this.routingProfiles = RoutingProfilesCopier.copy(routingProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfiles(String ... routingProfiles) {
            this.routingProfiles(Arrays.asList(routingProfiles));
            return this;
        }

        public final Collection<String> getRoutingStepExpressions() {
            if (this.routingStepExpressions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routingStepExpressions;
        }

        public final void setRoutingStepExpressions(Collection<String> routingStepExpressions) {
            this.routingStepExpressions = RoutingExpressionsCopier.copy(routingStepExpressions);
        }

        @Override
        public final Builder routingStepExpressions(Collection<String> routingStepExpressions) {
            this.routingStepExpressions = RoutingExpressionsCopier.copy(routingStepExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingStepExpressions(String ... routingStepExpressions) {
            this.routingStepExpressions(Arrays.asList(routingStepExpressions));
            return this;
        }

        public final Collection<String> getAgentStatuses() {
            if (this.agentStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentStatuses;
        }

        public final void setAgentStatuses(Collection<String> agentStatuses) {
            this.agentStatuses = AgentStatusesCopier.copy(agentStatuses);
        }

        @Override
        public final Builder agentStatuses(Collection<String> agentStatuses) {
            this.agentStatuses = AgentStatusesCopier.copy(agentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatuses(String ... agentStatuses) {
            this.agentStatuses(Arrays.asList(agentStatuses));
            return this;
        }

        public Filters build() {
            return new Filters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filters> {
        public Builder queues(Collection<String> var1);

        public Builder queues(String ... var1);

        public Builder channelsWithStrings(Collection<String> var1);

        public Builder channelsWithStrings(String ... var1);

        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);

        public Builder routingProfiles(Collection<String> var1);

        public Builder routingProfiles(String ... var1);

        public Builder routingStepExpressions(Collection<String> var1);

        public Builder routingStepExpressions(String ... var1);

        public Builder agentStatuses(Collection<String> var1);

        public Builder agentStatuses(String ... var1);
    }
}

