/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AutoEvaluationStatus;
import software.amazon.awssdk.services.connect.model.EvaluationAcknowledgementSummary;
import software.amazon.awssdk.services.connect.model.EvaluationContactParticipant;
import software.amazon.awssdk.services.connect.model.EvaluationScore;
import software.amazon.awssdk.services.connect.model.EvaluationStatus;
import software.amazon.awssdk.services.connect.model.EvaluationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationSummary> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationId").getter(EvaluationSummary.getter(EvaluationSummary::evaluationId)).setter(EvaluationSummary.setter(Builder::evaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationArn").getter(EvaluationSummary.getter(EvaluationSummary::evaluationArn)).setter(EvaluationSummary.setter(Builder::evaluationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormTitle").getter(EvaluationSummary.getter(EvaluationSummary::evaluationFormTitle)).setter(EvaluationSummary.setter(Builder::evaluationFormTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormTitle").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormId").getter(EvaluationSummary.getter(EvaluationSummary::evaluationFormId)).setter(EvaluationSummary.setter(Builder::evaluationFormId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()}).build();
    private static final SdkField<String> CALIBRATION_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalibrationSessionId").getter(EvaluationSummary.getter(EvaluationSummary::calibrationSessionId)).setter(EvaluationSummary.setter(Builder::calibrationSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalibrationSessionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EvaluationSummary.getter(EvaluationSummary::statusAsString)).setter(EvaluationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> AUTO_EVALUATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEvaluationEnabled").getter(EvaluationSummary.getter(EvaluationSummary::autoEvaluationEnabled)).setter(EvaluationSummary.setter(Builder::autoEvaluationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationEnabled").build()}).build();
    private static final SdkField<String> AUTO_EVALUATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEvaluationStatus").getter(EvaluationSummary.getter(EvaluationSummary::autoEvaluationStatusAsString)).setter(EvaluationSummary.setter(Builder::autoEvaluationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationStatus").build()}).build();
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatorArn").getter(EvaluationSummary.getter(EvaluationSummary::evaluatorArn)).setter(EvaluationSummary.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()}).build();
    private static final SdkField<EvaluationScore> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Score").getter(EvaluationSummary.getter(EvaluationSummary::score)).setter(EvaluationSummary.setter(Builder::score)).constructor(EvaluationScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<EvaluationAcknowledgementSummary> ACKNOWLEDGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Acknowledgement").getter(EvaluationSummary.getter(EvaluationSummary::acknowledgement)).setter(EvaluationSummary.setter(Builder::acknowledgement)).constructor(EvaluationAcknowledgementSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Acknowledgement").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(EvaluationSummary.getter(EvaluationSummary::evaluationTypeAsString)).setter(EvaluationSummary.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(EvaluationSummary.getter(EvaluationSummary::createdTime)).setter(EvaluationSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EvaluationSummary.getter(EvaluationSummary::lastModifiedTime)).setter(EvaluationSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<EvaluationContactParticipant> CONTACT_PARTICIPANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactParticipant").getter(EvaluationSummary.getter(EvaluationSummary::contactParticipant)).setter(EvaluationSummary.setter(Builder::contactParticipant)).constructor(EvaluationContactParticipant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactParticipant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD, EVALUATION_ARN_FIELD, EVALUATION_FORM_TITLE_FIELD, EVALUATION_FORM_ID_FIELD, CALIBRATION_SESSION_ID_FIELD, STATUS_FIELD, AUTO_EVALUATION_ENABLED_FIELD, AUTO_EVALUATION_STATUS_FIELD, EVALUATOR_ARN_FIELD, SCORE_FIELD, ACKNOWLEDGEMENT_FIELD, EVALUATION_TYPE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CONTACT_PARTICIPANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationId;
    private final String evaluationArn;
    private final String evaluationFormTitle;
    private final String evaluationFormId;
    private final String calibrationSessionId;
    private final String status;
    private final Boolean autoEvaluationEnabled;
    private final String autoEvaluationStatus;
    private final String evaluatorArn;
    private final EvaluationScore score;
    private final EvaluationAcknowledgementSummary acknowledgement;
    private final String evaluationType;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final EvaluationContactParticipant contactParticipant;

    private EvaluationSummary(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
        this.evaluationFormTitle = builder.evaluationFormTitle;
        this.evaluationFormId = builder.evaluationFormId;
        this.calibrationSessionId = builder.calibrationSessionId;
        this.status = builder.status;
        this.autoEvaluationEnabled = builder.autoEvaluationEnabled;
        this.autoEvaluationStatus = builder.autoEvaluationStatus;
        this.evaluatorArn = builder.evaluatorArn;
        this.score = builder.score;
        this.acknowledgement = builder.acknowledgement;
        this.evaluationType = builder.evaluationType;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.contactParticipant = builder.contactParticipant;
    }

    public final String evaluationId() {
        return this.evaluationId;
    }

    public final String evaluationArn() {
        return this.evaluationArn;
    }

    public final String evaluationFormTitle() {
        return this.evaluationFormTitle;
    }

    public final String evaluationFormId() {
        return this.evaluationFormId;
    }

    public final String calibrationSessionId() {
        return this.calibrationSessionId;
    }

    public final EvaluationStatus status() {
        return EvaluationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean autoEvaluationEnabled() {
        return this.autoEvaluationEnabled;
    }

    public final AutoEvaluationStatus autoEvaluationStatus() {
        return AutoEvaluationStatus.fromValue(this.autoEvaluationStatus);
    }

    public final String autoEvaluationStatusAsString() {
        return this.autoEvaluationStatus;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final EvaluationScore score() {
        return this.score;
    }

    public final EvaluationAcknowledgementSummary acknowledgement() {
        return this.acknowledgement;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final EvaluationContactParticipant contactParticipant() {
        return this.contactParticipant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(this.calibrationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgement());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactParticipant());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSummary)) {
            return false;
        }
        EvaluationSummary other = (EvaluationSummary)obj;
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationArn(), other.evaluationArn()) && Objects.equals(this.evaluationFormTitle(), other.evaluationFormTitle()) && Objects.equals(this.evaluationFormId(), other.evaluationFormId()) && Objects.equals(this.calibrationSessionId(), other.calibrationSessionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.autoEvaluationEnabled(), other.autoEvaluationEnabled()) && Objects.equals(this.autoEvaluationStatusAsString(), other.autoEvaluationStatusAsString()) && Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.acknowledgement(), other.acknowledgement()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.contactParticipant(), other.contactParticipant());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationSummary").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationArn", (Object)this.evaluationArn()).add("EvaluationFormTitle", (Object)this.evaluationFormTitle()).add("EvaluationFormId", (Object)this.evaluationFormId()).add("CalibrationSessionId", (Object)this.calibrationSessionId()).add("Status", (Object)this.statusAsString()).add("AutoEvaluationEnabled", (Object)this.autoEvaluationEnabled()).add("AutoEvaluationStatus", (Object)this.autoEvaluationStatusAsString()).add("EvaluatorArn", (Object)this.evaluatorArn()).add("Score", (Object)this.score()).add("Acknowledgement", (Object)this.acknowledgement()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("ContactParticipant", (Object)this.contactParticipant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "EvaluationArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationArn()));
            }
            case "EvaluationFormTitle": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormTitle()));
            }
            case "EvaluationFormId": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormId()));
            }
            case "CalibrationSessionId": {
                return Optional.ofNullable(clazz.cast(this.calibrationSessionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AutoEvaluationEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationEnabled()));
            }
            case "AutoEvaluationStatus": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationStatusAsString()));
            }
            case "EvaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "Acknowledgement": {
                return Optional.ofNullable(clazz.cast(this.acknowledgement()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "ContactParticipant": {
                return Optional.ofNullable(clazz.cast(this.contactParticipant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("EvaluationFormTitle", EVALUATION_FORM_TITLE_FIELD);
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("CalibrationSessionId", CALIBRATION_SESSION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AutoEvaluationEnabled", AUTO_EVALUATION_ENABLED_FIELD);
        map.put("AutoEvaluationStatus", AUTO_EVALUATION_STATUS_FIELD);
        map.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("Score", SCORE_FIELD);
        map.put("Acknowledgement", ACKNOWLEDGEMENT_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("ContactParticipant", CONTACT_PARTICIPANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSummary, T> g) {
        return obj -> g.apply((EvaluationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationArn;
        private String evaluationFormTitle;
        private String evaluationFormId;
        private String calibrationSessionId;
        private String status;
        private Boolean autoEvaluationEnabled;
        private String autoEvaluationStatus;
        private String evaluatorArn;
        private EvaluationScore score;
        private EvaluationAcknowledgementSummary acknowledgement;
        private String evaluationType;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private EvaluationContactParticipant contactParticipant;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSummary model) {
            this.evaluationId(model.evaluationId);
            this.evaluationArn(model.evaluationArn);
            this.evaluationFormTitle(model.evaluationFormTitle);
            this.evaluationFormId(model.evaluationFormId);
            this.calibrationSessionId(model.calibrationSessionId);
            this.status(model.status);
            this.autoEvaluationEnabled(model.autoEvaluationEnabled);
            this.autoEvaluationStatus(model.autoEvaluationStatus);
            this.evaluatorArn(model.evaluatorArn);
            this.score(model.score);
            this.acknowledgement(model.acknowledgement);
            this.evaluationType(model.evaluationType);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.contactParticipant(model.contactParticipant);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return this.evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final String getEvaluationFormTitle() {
            return this.evaluationFormTitle;
        }

        public final void setEvaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
        }

        @Override
        public final Builder evaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
            return this;
        }

        public final String getEvaluationFormId() {
            return this.evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final String getCalibrationSessionId() {
            return this.calibrationSessionId;
        }

        public final void setCalibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
        }

        @Override
        public final Builder calibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getAutoEvaluationEnabled() {
            return this.autoEvaluationEnabled;
        }

        public final void setAutoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
        }

        @Override
        public final Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
            return this;
        }

        public final String getAutoEvaluationStatus() {
            return this.autoEvaluationStatus;
        }

        public final void setAutoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
        }

        @Override
        public final Builder autoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
            return this;
        }

        @Override
        public final Builder autoEvaluationStatus(AutoEvaluationStatus autoEvaluationStatus) {
            this.autoEvaluationStatus(autoEvaluationStatus == null ? null : autoEvaluationStatus.toString());
            return this;
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final EvaluationScore.Builder getScore() {
            return this.score != null ? this.score.toBuilder() : null;
        }

        public final void setScore(EvaluationScore.BuilderImpl score) {
            this.score = score != null ? score.build() : null;
        }

        @Override
        public final Builder score(EvaluationScore score) {
            this.score = score;
            return this;
        }

        public final EvaluationAcknowledgementSummary.Builder getAcknowledgement() {
            return this.acknowledgement != null ? this.acknowledgement.toBuilder() : null;
        }

        public final void setAcknowledgement(EvaluationAcknowledgementSummary.BuilderImpl acknowledgement) {
            this.acknowledgement = acknowledgement != null ? acknowledgement.build() : null;
        }

        @Override
        public final Builder acknowledgement(EvaluationAcknowledgementSummary acknowledgement) {
            this.acknowledgement = acknowledgement;
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final EvaluationContactParticipant.Builder getContactParticipant() {
            return this.contactParticipant != null ? this.contactParticipant.toBuilder() : null;
        }

        public final void setContactParticipant(EvaluationContactParticipant.BuilderImpl contactParticipant) {
            this.contactParticipant = contactParticipant != null ? contactParticipant.build() : null;
        }

        @Override
        public final Builder contactParticipant(EvaluationContactParticipant contactParticipant) {
            this.contactParticipant = contactParticipant;
            return this;
        }

        public EvaluationSummary build() {
            return new EvaluationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationSummary> {
        public Builder evaluationId(String var1);

        public Builder evaluationArn(String var1);

        public Builder evaluationFormTitle(String var1);

        public Builder evaluationFormId(String var1);

        public Builder calibrationSessionId(String var1);

        public Builder status(String var1);

        public Builder status(EvaluationStatus var1);

        public Builder autoEvaluationEnabled(Boolean var1);

        public Builder autoEvaluationStatus(String var1);

        public Builder autoEvaluationStatus(AutoEvaluationStatus var1);

        public Builder evaluatorArn(String var1);

        public Builder score(EvaluationScore var1);

        default public Builder score(Consumer<EvaluationScore.Builder> score) {
            return this.score((EvaluationScore)((EvaluationScore.Builder)EvaluationScore.builder().applyMutation(score)).build());
        }

        public Builder acknowledgement(EvaluationAcknowledgementSummary var1);

        default public Builder acknowledgement(Consumer<EvaluationAcknowledgementSummary.Builder> acknowledgement) {
            return this.acknowledgement((EvaluationAcknowledgementSummary)((EvaluationAcknowledgementSummary.Builder)EvaluationAcknowledgementSummary.builder().applyMutation(acknowledgement)).build());
        }

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder contactParticipant(EvaluationContactParticipant var1);

        default public Builder contactParticipant(Consumer<EvaluationContactParticipant.Builder> contactParticipant) {
            return this.contactParticipant((EvaluationContactParticipant)((EvaluationContactParticipant.Builder)EvaluationContactParticipant.builder().applyMutation(contactParticipant)).build());
        }
    }
}

