/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EvaluationFormLanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormLanguageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormLanguageConfiguration> {
    private static final SdkField<String> FORM_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FormLanguage").getter(EvaluationFormLanguageConfiguration.getter(EvaluationFormLanguageConfiguration::formLanguageAsString)).setter(EvaluationFormLanguageConfiguration.setter(Builder::formLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORM_LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormLanguageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String formLanguage;

    private EvaluationFormLanguageConfiguration(BuilderImpl builder) {
        this.formLanguage = builder.formLanguage;
    }

    public final EvaluationFormLanguageCode formLanguage() {
        return EvaluationFormLanguageCode.fromValue(this.formLanguage);
    }

    public final String formLanguageAsString() {
        return this.formLanguage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formLanguageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormLanguageConfiguration)) {
            return false;
        }
        EvaluationFormLanguageConfiguration other = (EvaluationFormLanguageConfiguration)obj;
        return Objects.equals(this.formLanguageAsString(), other.formLanguageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormLanguageConfiguration").add("FormLanguage", (Object)this.formLanguageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FormLanguage": {
                return Optional.ofNullable(clazz.cast(this.formLanguageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FormLanguage", FORM_LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormLanguageConfiguration, T> g) {
        return obj -> g.apply((EvaluationFormLanguageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String formLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormLanguageConfiguration model) {
            this.formLanguage(model.formLanguage);
        }

        public final String getFormLanguage() {
            return this.formLanguage;
        }

        public final void setFormLanguage(String formLanguage) {
            this.formLanguage = formLanguage;
        }

        @Override
        public final Builder formLanguage(String formLanguage) {
            this.formLanguage = formLanguage;
            return this;
        }

        @Override
        public final Builder formLanguage(EvaluationFormLanguageCode formLanguage) {
            this.formLanguage(formLanguage == null ? null : formLanguage.toString());
            return this;
        }

        public EvaluationFormLanguageConfiguration build() {
            return new EvaluationFormLanguageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormLanguageConfiguration> {
        public Builder formLanguage(String var1);

        public Builder formLanguage(EvaluationFormLanguageCode var1);
    }
}

