/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.EvaluationFormAutoEvaluationConfiguration;
import software.amazon.awssdk.services.connect.model.EvaluationFormItem;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemsListCopier;
import software.amazon.awssdk.services.connect.model.EvaluationFormLanguageConfiguration;
import software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy;
import software.amazon.awssdk.services.connect.model.EvaluationFormTargetConfiguration;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEvaluationFormRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateEvaluationFormRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::instanceId)).setter(CreateEvaluationFormRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::title)).setter(CreateEvaluationFormRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::description)).setter(CreateEvaluationFormRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::items)).setter(CreateEvaluationFormRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormScoringStrategy> SCORING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScoringStrategy").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::scoringStrategy)).setter(CreateEvaluationFormRequest.setter(Builder::scoringStrategy)).constructor(EvaluationFormScoringStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoringStrategy").build()}).build();
    private static final SdkField<EvaluationFormAutoEvaluationConfiguration> AUTO_EVALUATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoEvaluationConfiguration").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::autoEvaluationConfiguration)).setter(CreateEvaluationFormRequest.setter(Builder::autoEvaluationConfiguration)).constructor(EvaluationFormAutoEvaluationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::clientToken)).setter(CreateEvaluationFormRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> AS_DRAFT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AsDraft").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::asDraft)).setter(CreateEvaluationFormRequest.setter(Builder::asDraft)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsDraft").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::tags)).setter(CreateEvaluationFormRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormTargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::targetConfiguration)).setter(CreateEvaluationFormRequest.setter(Builder::targetConfiguration)).constructor(EvaluationFormTargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final SdkField<EvaluationFormLanguageConfiguration> LANGUAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LanguageConfiguration").getter(CreateEvaluationFormRequest.getter(CreateEvaluationFormRequest::languageConfiguration)).setter(CreateEvaluationFormRequest.setter(Builder::languageConfiguration)).constructor(EvaluationFormLanguageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, ITEMS_FIELD, SCORING_STRATEGY_FIELD, AUTO_EVALUATION_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, AS_DRAFT_FIELD, TAGS_FIELD, TARGET_CONFIGURATION_FIELD, LANGUAGE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEvaluationFormRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String title;
    private final String description;
    private final List<EvaluationFormItem> items;
    private final EvaluationFormScoringStrategy scoringStrategy;
    private final EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration;
    private final String clientToken;
    private final Boolean asDraft;
    private final Map<String, String> tags;
    private final EvaluationFormTargetConfiguration targetConfiguration;
    private final EvaluationFormLanguageConfiguration languageConfiguration;

    private CreateEvaluationFormRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.title = builder.title;
        this.description = builder.description;
        this.items = builder.items;
        this.scoringStrategy = builder.scoringStrategy;
        this.autoEvaluationConfiguration = builder.autoEvaluationConfiguration;
        this.clientToken = builder.clientToken;
        this.asDraft = builder.asDraft;
        this.tags = builder.tags;
        this.targetConfiguration = builder.targetConfiguration;
        this.languageConfiguration = builder.languageConfiguration;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormItem> items() {
        return this.items;
    }

    public final EvaluationFormScoringStrategy scoringStrategy() {
        return this.scoringStrategy;
    }

    public final EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration() {
        return this.autoEvaluationConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean asDraft() {
        return this.asDraft;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final EvaluationFormTargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final EvaluationFormLanguageConfiguration languageConfiguration() {
        return this.languageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoringStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.asDraft());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationFormRequest)) {
            return false;
        }
        CreateEvaluationFormRequest other = (CreateEvaluationFormRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.scoringStrategy(), other.scoringStrategy()) && Objects.equals(this.autoEvaluationConfiguration(), other.autoEvaluationConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.asDraft(), other.asDraft()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && Objects.equals(this.languageConfiguration(), other.languageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEvaluationFormRequest").add("InstanceId", (Object)this.instanceId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Items", this.hasItems() ? this.items() : null).add("ScoringStrategy", (Object)this.scoringStrategy()).add("AutoEvaluationConfiguration", (Object)this.autoEvaluationConfiguration()).add("ClientToken", (Object)this.clientToken()).add("AsDraft", (Object)this.asDraft()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetConfiguration", (Object)this.targetConfiguration()).add("LanguageConfiguration", (Object)this.languageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "ScoringStrategy": {
                return Optional.ofNullable(clazz.cast(this.scoringStrategy()));
            }
            case "AutoEvaluationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "AsDraft": {
                return Optional.ofNullable(clazz.cast(this.asDraft()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "LanguageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.languageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("ScoringStrategy", SCORING_STRATEGY_FIELD);
        map.put("AutoEvaluationConfiguration", AUTO_EVALUATION_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("AsDraft", AS_DRAFT_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("LanguageConfiguration", LANGUAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEvaluationFormRequest, T> g) {
        return obj -> g.apply((CreateEvaluationFormRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String title;
        private String description;
        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();
        private EvaluationFormScoringStrategy scoringStrategy;
        private EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration;
        private String clientToken;
        private Boolean asDraft;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private EvaluationFormTargetConfiguration targetConfiguration;
        private EvaluationFormLanguageConfiguration languageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationFormRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.title(model.title);
            this.description(model.description);
            this.items(model.items);
            this.scoringStrategy(model.scoringStrategy);
            this.autoEvaluationConfiguration(model.autoEvaluationConfiguration);
            this.clientToken(model.clientToken);
            this.asDraft(model.asDraft);
            this.tags(model.tags);
            this.targetConfiguration(model.targetConfiguration);
            this.languageConfiguration(model.languageConfiguration);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (EvaluationFormItem)((EvaluationFormItem.Builder)EvaluationFormItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormScoringStrategy.Builder getScoringStrategy() {
            return this.scoringStrategy != null ? this.scoringStrategy.toBuilder() : null;
        }

        public final void setScoringStrategy(EvaluationFormScoringStrategy.BuilderImpl scoringStrategy) {
            this.scoringStrategy = scoringStrategy != null ? scoringStrategy.build() : null;
        }

        @Override
        public final Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        public final EvaluationFormAutoEvaluationConfiguration.Builder getAutoEvaluationConfiguration() {
            return this.autoEvaluationConfiguration != null ? this.autoEvaluationConfiguration.toBuilder() : null;
        }

        public final void setAutoEvaluationConfiguration(EvaluationFormAutoEvaluationConfiguration.BuilderImpl autoEvaluationConfiguration) {
            this.autoEvaluationConfiguration = autoEvaluationConfiguration != null ? autoEvaluationConfiguration.build() : null;
        }

        @Override
        public final Builder autoEvaluationConfiguration(EvaluationFormAutoEvaluationConfiguration autoEvaluationConfiguration) {
            this.autoEvaluationConfiguration = autoEvaluationConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getAsDraft() {
            return this.asDraft;
        }

        public final void setAsDraft(Boolean asDraft) {
            this.asDraft = asDraft;
        }

        @Override
        public final Builder asDraft(Boolean asDraft) {
            this.asDraft = asDraft;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final EvaluationFormTargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(EvaluationFormTargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(EvaluationFormTargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final EvaluationFormLanguageConfiguration.Builder getLanguageConfiguration() {
            return this.languageConfiguration != null ? this.languageConfiguration.toBuilder() : null;
        }

        public final void setLanguageConfiguration(EvaluationFormLanguageConfiguration.BuilderImpl languageConfiguration) {
            this.languageConfiguration = languageConfiguration != null ? languageConfiguration.build() : null;
        }

        @Override
        public final Builder languageConfiguration(EvaluationFormLanguageConfiguration languageConfiguration) {
            this.languageConfiguration = languageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEvaluationFormRequest build() {
            return new CreateEvaluationFormRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEvaluationFormRequest> {
        public Builder instanceId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder items(Collection<EvaluationFormItem> var1);

        public Builder items(EvaluationFormItem ... var1);

        public Builder items(Consumer<EvaluationFormItem.Builder> ... var1);

        public Builder scoringStrategy(EvaluationFormScoringStrategy var1);

        default public Builder scoringStrategy(Consumer<EvaluationFormScoringStrategy.Builder> scoringStrategy) {
            return this.scoringStrategy((EvaluationFormScoringStrategy)((EvaluationFormScoringStrategy.Builder)EvaluationFormScoringStrategy.builder().applyMutation(scoringStrategy)).build());
        }

        public Builder autoEvaluationConfiguration(EvaluationFormAutoEvaluationConfiguration var1);

        default public Builder autoEvaluationConfiguration(Consumer<EvaluationFormAutoEvaluationConfiguration.Builder> autoEvaluationConfiguration) {
            return this.autoEvaluationConfiguration((EvaluationFormAutoEvaluationConfiguration)((EvaluationFormAutoEvaluationConfiguration.Builder)EvaluationFormAutoEvaluationConfiguration.builder().applyMutation(autoEvaluationConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder asDraft(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetConfiguration(EvaluationFormTargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<EvaluationFormTargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((EvaluationFormTargetConfiguration)((EvaluationFormTargetConfiguration.Builder)EvaluationFormTargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder languageConfiguration(EvaluationFormLanguageConfiguration var1);

        default public Builder languageConfiguration(Consumer<EvaluationFormLanguageConfiguration.Builder> languageConfiguration) {
            return this.languageConfiguration((EvaluationFormLanguageConfiguration)((EvaluationFormLanguageConfiguration.Builder)EvaluationFormLanguageConfiguration.builder().applyMutation(languageConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

