/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ChatContactMetrics;
import software.amazon.awssdk.services.connect.model.ParticipantMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatMetrics> {
    private static final SdkField<ChatContactMetrics> CHAT_CONTACT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChatContactMetrics").getter(ChatMetrics.getter(ChatMetrics::chatContactMetrics)).setter(ChatMetrics.setter(Builder::chatContactMetrics)).constructor(ChatContactMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatContactMetrics").build()}).build();
    private static final SdkField<ParticipantMetrics> AGENT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentMetrics").getter(ChatMetrics.getter(ChatMetrics::agentMetrics)).setter(ChatMetrics.setter(Builder::agentMetrics)).constructor(ParticipantMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentMetrics").build()}).build();
    private static final SdkField<ParticipantMetrics> CUSTOMER_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerMetrics").getter(ChatMetrics.getter(ChatMetrics::customerMetrics)).setter(ChatMetrics.setter(Builder::customerMetrics)).constructor(ParticipantMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_CONTACT_METRICS_FIELD, AGENT_METRICS_FIELD, CUSTOMER_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ChatContactMetrics chatContactMetrics;
    private final ParticipantMetrics agentMetrics;
    private final ParticipantMetrics customerMetrics;

    private ChatMetrics(BuilderImpl builder) {
        this.chatContactMetrics = builder.chatContactMetrics;
        this.agentMetrics = builder.agentMetrics;
        this.customerMetrics = builder.customerMetrics;
    }

    public final ChatContactMetrics chatContactMetrics() {
        return this.chatContactMetrics;
    }

    public final ParticipantMetrics agentMetrics() {
        return this.agentMetrics;
    }

    public final ParticipantMetrics customerMetrics() {
        return this.customerMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chatContactMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatMetrics)) {
            return false;
        }
        ChatMetrics other = (ChatMetrics)obj;
        return Objects.equals(this.chatContactMetrics(), other.chatContactMetrics()) && Objects.equals(this.agentMetrics(), other.agentMetrics()) && Objects.equals(this.customerMetrics(), other.customerMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"ChatMetrics").add("ChatContactMetrics", (Object)this.chatContactMetrics()).add("AgentMetrics", (Object)this.agentMetrics()).add("CustomerMetrics", (Object)this.customerMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChatContactMetrics": {
                return Optional.ofNullable(clazz.cast(this.chatContactMetrics()));
            }
            case "AgentMetrics": {
                return Optional.ofNullable(clazz.cast(this.agentMetrics()));
            }
            case "CustomerMetrics": {
                return Optional.ofNullable(clazz.cast(this.customerMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChatContactMetrics", CHAT_CONTACT_METRICS_FIELD);
        map.put("AgentMetrics", AGENT_METRICS_FIELD);
        map.put("CustomerMetrics", CUSTOMER_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatMetrics, T> g) {
        return obj -> g.apply((ChatMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ChatContactMetrics chatContactMetrics;
        private ParticipantMetrics agentMetrics;
        private ParticipantMetrics customerMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatMetrics model) {
            this.chatContactMetrics(model.chatContactMetrics);
            this.agentMetrics(model.agentMetrics);
            this.customerMetrics(model.customerMetrics);
        }

        public final ChatContactMetrics.Builder getChatContactMetrics() {
            return this.chatContactMetrics != null ? this.chatContactMetrics.toBuilder() : null;
        }

        public final void setChatContactMetrics(ChatContactMetrics.BuilderImpl chatContactMetrics) {
            this.chatContactMetrics = chatContactMetrics != null ? chatContactMetrics.build() : null;
        }

        @Override
        public final Builder chatContactMetrics(ChatContactMetrics chatContactMetrics) {
            this.chatContactMetrics = chatContactMetrics;
            return this;
        }

        public final ParticipantMetrics.Builder getAgentMetrics() {
            return this.agentMetrics != null ? this.agentMetrics.toBuilder() : null;
        }

        public final void setAgentMetrics(ParticipantMetrics.BuilderImpl agentMetrics) {
            this.agentMetrics = agentMetrics != null ? agentMetrics.build() : null;
        }

        @Override
        public final Builder agentMetrics(ParticipantMetrics agentMetrics) {
            this.agentMetrics = agentMetrics;
            return this;
        }

        public final ParticipantMetrics.Builder getCustomerMetrics() {
            return this.customerMetrics != null ? this.customerMetrics.toBuilder() : null;
        }

        public final void setCustomerMetrics(ParticipantMetrics.BuilderImpl customerMetrics) {
            this.customerMetrics = customerMetrics != null ? customerMetrics.build() : null;
        }

        @Override
        public final Builder customerMetrics(ParticipantMetrics customerMetrics) {
            this.customerMetrics = customerMetrics;
            return this;
        }

        public ChatMetrics build() {
            return new ChatMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatMetrics> {
        public Builder chatContactMetrics(ChatContactMetrics var1);

        default public Builder chatContactMetrics(Consumer<ChatContactMetrics.Builder> chatContactMetrics) {
            return this.chatContactMetrics((ChatContactMetrics)((ChatContactMetrics.Builder)ChatContactMetrics.builder().applyMutation(chatContactMetrics)).build());
        }

        public Builder agentMetrics(ParticipantMetrics var1);

        default public Builder agentMetrics(Consumer<ParticipantMetrics.Builder> agentMetrics) {
            return this.agentMetrics((ParticipantMetrics)((ParticipantMetrics.Builder)ParticipantMetrics.builder().applyMutation(agentMetrics)).build());
        }

        public Builder customerMetrics(ParticipantMetrics var1);

        default public Builder customerMetrics(Consumer<ParticipantMetrics.Builder> customerMetrics) {
            return this.customerMetrics((ParticipantMetrics)((ParticipantMetrics.Builder)ParticipantMetrics.builder().applyMutation(customerMetrics)).build());
        }
    }
}

