/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesResponse;
import software.amazon.awssdk.services.connect.model.WorkspacePage;

public class ListWorkspacePagesIterable
implements SdkIterable<ListWorkspacePagesResponse> {
    private final ConnectClient client;
    private final ListWorkspacePagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkspacePagesIterable(ConnectClient client, ListWorkspacePagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkspacePagesResponseFetcher();
    }

    public Iterator<ListWorkspacePagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkspacePage> workspacePageList() {
        Function<ListWorkspacePagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspacePageList() != null) {
                return response.workspacePageList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkspacePagesResponseFetcher
    implements SyncPageFetcher<ListWorkspacePagesResponse> {
        private ListWorkspacePagesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspacePagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkspacePagesResponse nextPage(ListWorkspacePagesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspacePagesIterable.this.client.listWorkspacePages(ListWorkspacePagesIterable.this.firstRequest);
            }
            return ListWorkspacePagesIterable.this.client.listWorkspacePages((ListWorkspacePagesRequest)((Object)ListWorkspacePagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

