/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleVersionSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsResponse;

public class ListContactFlowModuleVersionsIterable
implements SdkIterable<ListContactFlowModuleVersionsResponse> {
    private final ConnectClient client;
    private final ListContactFlowModuleVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactFlowModuleVersionsIterable(ConnectClient client, ListContactFlowModuleVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactFlowModuleVersionsResponseFetcher();
    }

    public Iterator<ListContactFlowModuleVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlowModuleVersionSummary> contactFlowModuleVersionSummaryList() {
        Function<ListContactFlowModuleVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModuleVersionSummaryList() != null) {
                return response.contactFlowModuleVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactFlowModuleVersionsResponseFetcher
    implements SyncPageFetcher<ListContactFlowModuleVersionsResponse> {
        private ListContactFlowModuleVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowModuleVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactFlowModuleVersionsResponse nextPage(ListContactFlowModuleVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowModuleVersionsIterable.this.client.listContactFlowModuleVersions(ListContactFlowModuleVersionsIterable.this.firstRequest);
            }
            return ListContactFlowModuleVersionsIterable.this.client.listContactFlowModuleVersions((ListContactFlowModuleVersionsRequest)((Object)ListContactFlowModuleVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

