/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleAliasSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesResponse;

public class ListContactFlowModuleAliasesIterable
implements SdkIterable<ListContactFlowModuleAliasesResponse> {
    private final ConnectClient client;
    private final ListContactFlowModuleAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactFlowModuleAliasesIterable(ConnectClient client, ListContactFlowModuleAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactFlowModuleAliasesResponseFetcher();
    }

    public Iterator<ListContactFlowModuleAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList() {
        Function<ListContactFlowModuleAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModuleAliasSummaryList() != null) {
                return response.contactFlowModuleAliasSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactFlowModuleAliasesResponseFetcher
    implements SyncPageFetcher<ListContactFlowModuleAliasesResponse> {
        private ListContactFlowModuleAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowModuleAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactFlowModuleAliasesResponse nextPage(ListContactFlowModuleAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowModuleAliasesIterable.this.client.listContactFlowModuleAliases(ListContactFlowModuleAliasesIterable.this.firstRequest);
            }
            return ListContactFlowModuleAliasesIterable.this.client.listContactFlowModuleAliases((ListContactFlowModuleAliasesRequest)((Object)ListContactFlowModuleAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

