/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.StringCondition;
import software.amazon.awssdk.services.connect.model.ViewSearchConditionListCopier;
import software.amazon.awssdk.services.connect.model.ViewStatus;
import software.amazon.awssdk.services.connect.model.ViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewSearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewSearchCriteria> {
    private static final SdkField<List<ViewSearchCriteria>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(ViewSearchCriteria.getter(ViewSearchCriteria::orConditions)).setter(ViewSearchCriteria.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ViewSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ViewSearchCriteria>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AndConditions").getter(ViewSearchCriteria.getter(ViewSearchCriteria::andConditions)).setter(ViewSearchCriteria.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ViewSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringCondition").getter(ViewSearchCriteria.getter(ViewSearchCriteria::stringCondition)).setter(ViewSearchCriteria.setter(Builder::stringCondition)).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()}).build();
    private static final SdkField<String> VIEW_TYPE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewTypeCondition").getter(ViewSearchCriteria.getter(ViewSearchCriteria::viewTypeConditionAsString)).setter(ViewSearchCriteria.setter(Builder::viewTypeCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewTypeCondition").build()}).build();
    private static final SdkField<String> VIEW_STATUS_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewStatusCondition").getter(ViewSearchCriteria.getter(ViewSearchCriteria::viewStatusConditionAsString)).setter(ViewSearchCriteria.setter(Builder::viewStatusCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewStatusCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, VIEW_TYPE_CONDITION_FIELD, VIEW_STATUS_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViewSearchCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ViewSearchCriteria> orConditions;
    private final List<ViewSearchCriteria> andConditions;
    private final StringCondition stringCondition;
    private final String viewTypeCondition;
    private final String viewStatusCondition;

    private ViewSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.viewTypeCondition = builder.viewTypeCondition;
        this.viewStatusCondition = builder.viewStatusCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<ViewSearchCriteria> orConditions() {
        return this.orConditions;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<ViewSearchCriteria> andConditions() {
        return this.andConditions;
    }

    public final StringCondition stringCondition() {
        return this.stringCondition;
    }

    public final ViewType viewTypeCondition() {
        return ViewType.fromValue(this.viewTypeCondition);
    }

    public final String viewTypeConditionAsString() {
        return this.viewTypeCondition;
    }

    public final ViewStatus viewStatusCondition() {
        return ViewStatus.fromValue(this.viewStatusCondition);
    }

    public final String viewStatusConditionAsString() {
        return this.viewStatusCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewTypeConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewStatusConditionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewSearchCriteria)) {
            return false;
        }
        ViewSearchCriteria other = (ViewSearchCriteria)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && Objects.equals(this.stringCondition(), other.stringCondition()) && Objects.equals(this.viewTypeConditionAsString(), other.viewTypeConditionAsString()) && Objects.equals(this.viewStatusConditionAsString(), other.viewStatusConditionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ViewSearchCriteria").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("StringCondition", (Object)this.stringCondition()).add("ViewTypeCondition", (Object)this.viewTypeConditionAsString()).add("ViewStatusCondition", (Object)this.viewStatusConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "StringCondition": {
                return Optional.ofNullable(clazz.cast(this.stringCondition()));
            }
            case "ViewTypeCondition": {
                return Optional.ofNullable(clazz.cast(this.viewTypeConditionAsString()));
            }
            case "ViewStatusCondition": {
                return Optional.ofNullable(clazz.cast(this.viewStatusConditionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndConditions", AND_CONDITIONS_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        map.put("ViewTypeCondition", VIEW_TYPE_CONDITION_FIELD);
        map.put("ViewStatusCondition", VIEW_STATUS_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewSearchCriteria, T> g) {
        return obj -> g.apply((ViewSearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ViewSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();
        private List<ViewSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();
        private StringCondition stringCondition;
        private String viewTypeCondition;
        private String viewStatusCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewSearchCriteria model) {
            this.orConditions(model.orConditions);
            this.andConditions(model.andConditions);
            this.stringCondition(model.stringCondition);
            this.viewTypeCondition(model.viewTypeCondition);
            this.viewStatusCondition(model.viewStatusCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = ViewSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = ViewSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ViewSearchCriteria> orConditions) {
            this.orConditions = ViewSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ViewSearchCriteria ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (ViewSearchCriteria)((Builder)ViewSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = ViewSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = ViewSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<ViewSearchCriteria> andConditions) {
            this.andConditions = ViewSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(ViewSearchCriteria ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (ViewSearchCriteria)((Builder)ViewSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return this.stringCondition != null ? this.stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getViewTypeCondition() {
            return this.viewTypeCondition;
        }

        public final void setViewTypeCondition(String viewTypeCondition) {
            this.viewTypeCondition = viewTypeCondition;
        }

        @Override
        public final Builder viewTypeCondition(String viewTypeCondition) {
            this.viewTypeCondition = viewTypeCondition;
            return this;
        }

        @Override
        public final Builder viewTypeCondition(ViewType viewTypeCondition) {
            this.viewTypeCondition(viewTypeCondition == null ? null : viewTypeCondition.toString());
            return this;
        }

        public final String getViewStatusCondition() {
            return this.viewStatusCondition;
        }

        public final void setViewStatusCondition(String viewStatusCondition) {
            this.viewStatusCondition = viewStatusCondition;
        }

        @Override
        public final Builder viewStatusCondition(String viewStatusCondition) {
            this.viewStatusCondition = viewStatusCondition;
            return this;
        }

        @Override
        public final Builder viewStatusCondition(ViewStatus viewStatusCondition) {
            this.viewStatusCondition(viewStatusCondition == null ? null : viewStatusCondition.toString());
            return this;
        }

        public ViewSearchCriteria build() {
            return new ViewSearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewSearchCriteria> {
        public Builder orConditions(Collection<ViewSearchCriteria> var1);

        public Builder orConditions(ViewSearchCriteria ... var1);

        public Builder orConditions(Consumer<Builder> ... var1);

        public Builder andConditions(Collection<ViewSearchCriteria> var1);

        public Builder andConditions(ViewSearchCriteria ... var1);

        public Builder andConditions(Consumer<Builder> ... var1);

        public Builder stringCondition(StringCondition var1);

        default public Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return this.stringCondition((StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation(stringCondition)).build());
        }

        public Builder viewTypeCondition(String var1);

        public Builder viewTypeCondition(ViewType var1);

        public Builder viewStatusCondition(String var1);

        public Builder viewStatusCondition(ViewStatus var1);
    }
}

