/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceSearchSummary;
import software.amazon.awssdk.services.connect.model.WorkspaceSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchWorkspacesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchWorkspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchWorkspacesResponse.getter(SearchWorkspacesResponse::nextToken)).setter(SearchWorkspacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WorkspaceSearchSummary>> WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Workspaces").getter(SearchWorkspacesResponse.getter(SearchWorkspacesResponse::workspaces)).setter(SearchWorkspacesResponse.setter(Builder::workspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchWorkspacesResponse.getter(SearchWorkspacesResponse::approximateTotalCount)).setter(SearchWorkspacesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKSPACES_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchWorkspacesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WorkspaceSearchSummary> workspaces;
    private final Long approximateTotalCount;

    private SearchWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspaces = builder.workspaces;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkspaces() {
        return this.workspaces != null && !(this.workspaces instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceSearchSummary> workspaces() {
        return this.workspaces;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaces() ? this.workspaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchWorkspacesResponse)) {
            return false;
        }
        SearchWorkspacesResponse other = (SearchWorkspacesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkspaces() == other.hasWorkspaces() && Objects.equals(this.workspaces(), other.workspaces()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchWorkspacesResponse").add("NextToken", (Object)this.nextToken()).add("Workspaces", this.hasWorkspaces() ? this.workspaces() : null).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Workspaces": {
                return Optional.ofNullable(clazz.cast(this.workspaces()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Workspaces", WORKSPACES_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchWorkspacesResponse, T> g) {
        return obj -> g.apply((SearchWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkspaceSearchSummary> workspaces = DefaultSdkAutoConstructList.getInstance();
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchWorkspacesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workspaces(model.workspaces);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspaceSearchSummary.Builder> getWorkspaces() {
            List<WorkspaceSearchSummary.Builder> result = WorkspaceSearchSummaryListCopier.copyToBuilder(this.workspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaces(Collection<WorkspaceSearchSummary.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceSearchSummaryListCopier.copyFromBuilder(workspaces);
        }

        @Override
        public final Builder workspaces(Collection<WorkspaceSearchSummary> workspaces) {
            this.workspaces = WorkspaceSearchSummaryListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(WorkspaceSearchSummary ... workspaces) {
            this.workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<WorkspaceSearchSummary.Builder> ... workspaces) {
            this.workspaces(Stream.of(workspaces).map(c -> (WorkspaceSearchSummary)((WorkspaceSearchSummary.Builder)WorkspaceSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchWorkspacesResponse build() {
            return new SearchWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchWorkspacesResponse> {
        public Builder nextToken(String var1);

        public Builder workspaces(Collection<WorkspaceSearchSummary> var1);

        public Builder workspaces(WorkspaceSearchSummary ... var1);

        public Builder workspaces(Consumer<WorkspaceSearchSummary.Builder> ... var1);

        public Builder approximateTotalCount(Long var1);
    }
}

