/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AllowedFlowModulesCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.FlowModule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfileFlowModulesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListSecurityProfileFlowModulesResponse> {
    private static final SdkField<List<FlowModule>> ALLOWED_FLOW_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedFlowModules").getter(ListSecurityProfileFlowModulesResponse.getter(ListSecurityProfileFlowModulesResponse::allowedFlowModules)).setter(ListSecurityProfileFlowModulesResponse.setter(Builder::allowedFlowModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedFlowModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowModule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSecurityProfileFlowModulesResponse.getter(ListSecurityProfileFlowModulesResponse::nextToken)).setter(ListSecurityProfileFlowModulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ListSecurityProfileFlowModulesResponse.getter(ListSecurityProfileFlowModulesResponse::lastModifiedTime)).setter(ListSecurityProfileFlowModulesResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(ListSecurityProfileFlowModulesResponse.getter(ListSecurityProfileFlowModulesResponse::lastModifiedRegion)).setter(ListSecurityProfileFlowModulesResponse.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_FLOW_MODULES_FIELD, NEXT_TOKEN_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSecurityProfileFlowModulesResponse.memberNameToFieldInitializer();
    private final List<FlowModule> allowedFlowModules;
    private final String nextToken;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private ListSecurityProfileFlowModulesResponse(BuilderImpl builder) {
        super(builder);
        this.allowedFlowModules = builder.allowedFlowModules;
        this.nextToken = builder.nextToken;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final boolean hasAllowedFlowModules() {
        return this.allowedFlowModules != null && !(this.allowedFlowModules instanceof SdkAutoConstructList);
    }

    public final List<FlowModule> allowedFlowModules() {
        return this.allowedFlowModules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedFlowModules() ? this.allowedFlowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfileFlowModulesResponse)) {
            return false;
        }
        ListSecurityProfileFlowModulesResponse other = (ListSecurityProfileFlowModulesResponse)((Object)obj);
        return this.hasAllowedFlowModules() == other.hasAllowedFlowModules() && Objects.equals(this.allowedFlowModules(), other.allowedFlowModules()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityProfileFlowModulesResponse").add("AllowedFlowModules", this.hasAllowedFlowModules() ? this.allowedFlowModules() : null).add("NextToken", (Object)this.nextToken()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedFlowModules": {
                return Optional.ofNullable(clazz.cast(this.allowedFlowModules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllowedFlowModules", ALLOWED_FLOW_MODULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfileFlowModulesResponse, T> g) {
        return obj -> g.apply((ListSecurityProfileFlowModulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<FlowModule> allowedFlowModules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfileFlowModulesResponse model) {
            super(model);
            this.allowedFlowModules(model.allowedFlowModules);
            this.nextToken(model.nextToken);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final List<FlowModule.Builder> getAllowedFlowModules() {
            List<FlowModule.Builder> result = AllowedFlowModulesCopier.copyToBuilder(this.allowedFlowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedFlowModules(Collection<FlowModule.BuilderImpl> allowedFlowModules) {
            this.allowedFlowModules = AllowedFlowModulesCopier.copyFromBuilder(allowedFlowModules);
        }

        @Override
        public final Builder allowedFlowModules(Collection<FlowModule> allowedFlowModules) {
            this.allowedFlowModules = AllowedFlowModulesCopier.copy(allowedFlowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFlowModules(FlowModule ... allowedFlowModules) {
            this.allowedFlowModules(Arrays.asList(allowedFlowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFlowModules(Consumer<FlowModule.Builder> ... allowedFlowModules) {
            this.allowedFlowModules(Stream.of(allowedFlowModules).map(c -> (FlowModule)((FlowModule.Builder)FlowModule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ListSecurityProfileFlowModulesResponse build() {
            return new ListSecurityProfileFlowModulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityProfileFlowModulesResponse> {
        public Builder allowedFlowModules(Collection<FlowModule> var1);

        public Builder allowedFlowModules(FlowModule ... var1);

        public Builder allowedFlowModules(Consumer<FlowModule.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

