/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileManualAssignmentQueueConfigSummary;
import software.amazon.awssdk.services.connect.model.RoutingProfileManualAssignmentQueueConfigSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoutingProfileManualAssignmentQueuesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListRoutingProfileManualAssignmentQueuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoutingProfileManualAssignmentQueuesResponse.getter(ListRoutingProfileManualAssignmentQueuesResponse::nextToken)).setter(ListRoutingProfileManualAssignmentQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RoutingProfileManualAssignmentQueueConfigSummary>> ROUTING_PROFILE_MANUAL_ASSIGNMENT_QUEUE_CONFIG_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoutingProfileManualAssignmentQueueConfigSummaryList").getter(ListRoutingProfileManualAssignmentQueuesResponse.getter(ListRoutingProfileManualAssignmentQueuesResponse::routingProfileManualAssignmentQueueConfigSummaryList)).setter(ListRoutingProfileManualAssignmentQueuesResponse.setter(Builder::routingProfileManualAssignmentQueueConfigSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileManualAssignmentQueueConfigSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileManualAssignmentQueueConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ListRoutingProfileManualAssignmentQueuesResponse.getter(ListRoutingProfileManualAssignmentQueuesResponse::lastModifiedTime)).setter(ListRoutingProfileManualAssignmentQueuesResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(ListRoutingProfileManualAssignmentQueuesResponse.getter(ListRoutingProfileManualAssignmentQueuesResponse::lastModifiedRegion)).setter(ListRoutingProfileManualAssignmentQueuesResponse.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ROUTING_PROFILE_MANUAL_ASSIGNMENT_QUEUE_CONFIG_SUMMARY_LIST_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRoutingProfileManualAssignmentQueuesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RoutingProfileManualAssignmentQueueConfigSummary> routingProfileManualAssignmentQueueConfigSummaryList;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private ListRoutingProfileManualAssignmentQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.routingProfileManualAssignmentQueueConfigSummaryList = builder.routingProfileManualAssignmentQueueConfigSummaryList;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRoutingProfileManualAssignmentQueueConfigSummaryList() {
        return this.routingProfileManualAssignmentQueueConfigSummaryList != null && !(this.routingProfileManualAssignmentQueueConfigSummaryList instanceof SdkAutoConstructList);
    }

    public final List<RoutingProfileManualAssignmentQueueConfigSummary> routingProfileManualAssignmentQueueConfigSummaryList() {
        return this.routingProfileManualAssignmentQueueConfigSummaryList;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingProfileManualAssignmentQueueConfigSummaryList() ? this.routingProfileManualAssignmentQueueConfigSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingProfileManualAssignmentQueuesResponse)) {
            return false;
        }
        ListRoutingProfileManualAssignmentQueuesResponse other = (ListRoutingProfileManualAssignmentQueuesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRoutingProfileManualAssignmentQueueConfigSummaryList() == other.hasRoutingProfileManualAssignmentQueueConfigSummaryList() && Objects.equals(this.routingProfileManualAssignmentQueueConfigSummaryList(), other.routingProfileManualAssignmentQueueConfigSummaryList()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoutingProfileManualAssignmentQueuesResponse").add("NextToken", (Object)this.nextToken()).add("RoutingProfileManualAssignmentQueueConfigSummaryList", this.hasRoutingProfileManualAssignmentQueueConfigSummaryList() ? this.routingProfileManualAssignmentQueueConfigSummaryList() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RoutingProfileManualAssignmentQueueConfigSummaryList": {
                return Optional.ofNullable(clazz.cast(this.routingProfileManualAssignmentQueueConfigSummaryList()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RoutingProfileManualAssignmentQueueConfigSummaryList", ROUTING_PROFILE_MANUAL_ASSIGNMENT_QUEUE_CONFIG_SUMMARY_LIST_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingProfileManualAssignmentQueuesResponse, T> g) {
        return obj -> g.apply((ListRoutingProfileManualAssignmentQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RoutingProfileManualAssignmentQueueConfigSummary> routingProfileManualAssignmentQueueConfigSummaryList = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingProfileManualAssignmentQueuesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.routingProfileManualAssignmentQueueConfigSummaryList(model.routingProfileManualAssignmentQueueConfigSummaryList);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RoutingProfileManualAssignmentQueueConfigSummary.Builder> getRoutingProfileManualAssignmentQueueConfigSummaryList() {
            List<RoutingProfileManualAssignmentQueueConfigSummary.Builder> result = RoutingProfileManualAssignmentQueueConfigSummaryListCopier.copyToBuilder(this.routingProfileManualAssignmentQueueConfigSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingProfileManualAssignmentQueueConfigSummaryList(Collection<RoutingProfileManualAssignmentQueueConfigSummary.BuilderImpl> routingProfileManualAssignmentQueueConfigSummaryList) {
            this.routingProfileManualAssignmentQueueConfigSummaryList = RoutingProfileManualAssignmentQueueConfigSummaryListCopier.copyFromBuilder(routingProfileManualAssignmentQueueConfigSummaryList);
        }

        @Override
        public final Builder routingProfileManualAssignmentQueueConfigSummaryList(Collection<RoutingProfileManualAssignmentQueueConfigSummary> routingProfileManualAssignmentQueueConfigSummaryList) {
            this.routingProfileManualAssignmentQueueConfigSummaryList = RoutingProfileManualAssignmentQueueConfigSummaryListCopier.copy(routingProfileManualAssignmentQueueConfigSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileManualAssignmentQueueConfigSummaryList(RoutingProfileManualAssignmentQueueConfigSummary ... routingProfileManualAssignmentQueueConfigSummaryList) {
            this.routingProfileManualAssignmentQueueConfigSummaryList(Arrays.asList(routingProfileManualAssignmentQueueConfigSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileManualAssignmentQueueConfigSummaryList(Consumer<RoutingProfileManualAssignmentQueueConfigSummary.Builder> ... routingProfileManualAssignmentQueueConfigSummaryList) {
            this.routingProfileManualAssignmentQueueConfigSummaryList(Stream.of(routingProfileManualAssignmentQueueConfigSummaryList).map(c -> (RoutingProfileManualAssignmentQueueConfigSummary)((RoutingProfileManualAssignmentQueueConfigSummary.Builder)RoutingProfileManualAssignmentQueueConfigSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ListRoutingProfileManualAssignmentQueuesResponse build() {
            return new ListRoutingProfileManualAssignmentQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoutingProfileManualAssignmentQueuesResponse> {
        public Builder nextToken(String var1);

        public Builder routingProfileManualAssignmentQueueConfigSummaryList(Collection<RoutingProfileManualAssignmentQueueConfigSummary> var1);

        public Builder routingProfileManualAssignmentQueueConfigSummaryList(RoutingProfileManualAssignmentQueueConfigSummary ... var1);

        public Builder routingProfileManualAssignmentQueueConfigSummaryList(Consumer<RoutingProfileManualAssignmentQueueConfigSummary.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

