/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.PrimaryAttributeValueFilter;
import software.amazon.awssdk.services.connect.model.PrimaryAttributeValueFiltersCopier;
import software.amazon.awssdk.services.connect.model.RecordIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataTableValuesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListDataTableValuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListDataTableValuesRequest.getter(ListDataTableValuesRequest::instanceId)).setter(ListDataTableValuesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableId").getter(ListDataTableValuesRequest.getter(ListDataTableValuesRequest::dataTableId)).setter(ListDataTableValuesRequest.setter(Builder::dataTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()}).build();
    private static final SdkField<List<String>> RECORD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordIds").getter(ListDataTableValuesRequest.getter(ListDataTableValuesRequest::recordIds)).setter(ListDataTableValuesRequest.setter(Builder::recordIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrimaryAttributeValueFilter>> PRIMARY_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryAttributeValues").getter(ListDataTableValuesRequest.getter(ListDataTableValuesRequest::primaryAttributeValues)).setter(ListDataTableValuesRequest.setter(Builder::primaryAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAttributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrimaryAttributeValueFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataTableValuesRequest.getter(ListDataTableValuesRequest::nextToken)).setter(ListDataTableValuesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDataTableValuesRequest.getter(ListDataTableValuesRequest::maxResults)).setter(ListDataTableValuesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DATA_TABLE_ID_FIELD, RECORD_IDS_FIELD, PRIMARY_ATTRIBUTE_VALUES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataTableValuesRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String dataTableId;
    private final List<String> recordIds;
    private final List<PrimaryAttributeValueFilter> primaryAttributeValues;
    private final String nextToken;
    private final Integer maxResults;

    private ListDataTableValuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.recordIds = builder.recordIds;
        this.primaryAttributeValues = builder.primaryAttributeValues;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String dataTableId() {
        return this.dataTableId;
    }

    public final boolean hasRecordIds() {
        return this.recordIds != null && !(this.recordIds instanceof SdkAutoConstructList);
    }

    public final List<String> recordIds() {
        return this.recordIds;
    }

    public final boolean hasPrimaryAttributeValues() {
        return this.primaryAttributeValues != null && !(this.primaryAttributeValues instanceof SdkAutoConstructList);
    }

    public final List<PrimaryAttributeValueFilter> primaryAttributeValues() {
        return this.primaryAttributeValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordIds() ? this.recordIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryAttributeValues() ? this.primaryAttributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataTableValuesRequest)) {
            return false;
        }
        ListDataTableValuesRequest other = (ListDataTableValuesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.dataTableId(), other.dataTableId()) && this.hasRecordIds() == other.hasRecordIds() && Objects.equals(this.recordIds(), other.recordIds()) && this.hasPrimaryAttributeValues() == other.hasPrimaryAttributeValues() && Objects.equals(this.primaryAttributeValues(), other.primaryAttributeValues()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataTableValuesRequest").add("InstanceId", (Object)this.instanceId()).add("DataTableId", (Object)this.dataTableId()).add("RecordIds", this.hasRecordIds() ? this.recordIds() : null).add("PrimaryAttributeValues", this.hasPrimaryAttributeValues() ? this.primaryAttributeValues() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DataTableId": {
                return Optional.ofNullable(clazz.cast(this.dataTableId()));
            }
            case "RecordIds": {
                return Optional.ofNullable(clazz.cast(this.recordIds()));
            }
            case "PrimaryAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.primaryAttributeValues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("RecordIds", RECORD_IDS_FIELD);
        map.put("PrimaryAttributeValues", PRIMARY_ATTRIBUTE_VALUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataTableValuesRequest, T> g) {
        return obj -> g.apply((ListDataTableValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String dataTableId;
        private List<String> recordIds = DefaultSdkAutoConstructList.getInstance();
        private List<PrimaryAttributeValueFilter> primaryAttributeValues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataTableValuesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.dataTableId(model.dataTableId);
            this.recordIds(model.recordIds);
            this.primaryAttributeValues(model.primaryAttributeValues);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return this.dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final Collection<String> getRecordIds() {
            if (this.recordIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordIds;
        }

        public final void setRecordIds(Collection<String> recordIds) {
            this.recordIds = RecordIdsCopier.copy(recordIds);
        }

        @Override
        public final Builder recordIds(Collection<String> recordIds) {
            this.recordIds = RecordIdsCopier.copy(recordIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordIds(String ... recordIds) {
            this.recordIds(Arrays.asList(recordIds));
            return this;
        }

        public final List<PrimaryAttributeValueFilter.Builder> getPrimaryAttributeValues() {
            List<PrimaryAttributeValueFilter.Builder> result = PrimaryAttributeValueFiltersCopier.copyToBuilder(this.primaryAttributeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryAttributeValues(Collection<PrimaryAttributeValueFilter.BuilderImpl> primaryAttributeValues) {
            this.primaryAttributeValues = PrimaryAttributeValueFiltersCopier.copyFromBuilder(primaryAttributeValues);
        }

        @Override
        public final Builder primaryAttributeValues(Collection<PrimaryAttributeValueFilter> primaryAttributeValues) {
            this.primaryAttributeValues = PrimaryAttributeValueFiltersCopier.copy(primaryAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryAttributeValues(PrimaryAttributeValueFilter ... primaryAttributeValues) {
            this.primaryAttributeValues(Arrays.asList(primaryAttributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryAttributeValues(Consumer<PrimaryAttributeValueFilter.Builder> ... primaryAttributeValues) {
            this.primaryAttributeValues(Stream.of(primaryAttributeValues).map(c -> (PrimaryAttributeValueFilter)((PrimaryAttributeValueFilter.Builder)PrimaryAttributeValueFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataTableValuesRequest build() {
            return new ListDataTableValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataTableValuesRequest> {
        public Builder instanceId(String var1);

        public Builder dataTableId(String var1);

        public Builder recordIds(Collection<String> var1);

        public Builder recordIds(String ... var1);

        public Builder primaryAttributeValues(Collection<PrimaryAttributeValueFilter> var1);

        public Builder primaryAttributeValues(PrimaryAttributeValueFilter ... var1);

        public Builder primaryAttributeValues(Consumer<PrimaryAttributeValueFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

