/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ContactInteractionType;
import software.amazon.awssdk.services.connect.model.EvaluationFormLanguageCode;
import software.amazon.awssdk.services.connect.model.EvaluationFormVersionStatus;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormSearchSummary> {
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormId").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::evaluationFormId)).setter(EvaluationFormSearchSummary.setter(Builder::evaluationFormId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormArn").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::evaluationFormArn)).setter(EvaluationFormSearchSummary.setter(Builder::evaluationFormArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::title)).setter(EvaluationFormSearchSummary.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::statusAsString)).setter(EvaluationFormSearchSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::description)).setter(EvaluationFormSearchSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::createdTime)).setter(EvaluationFormSearchSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::createdBy)).setter(EvaluationFormSearchSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::lastModifiedTime)).setter(EvaluationFormSearchSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::lastModifiedBy)).setter(EvaluationFormSearchSummary.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_ACTIVATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastActivatedTime").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::lastActivatedTime)).setter(EvaluationFormSearchSummary.setter(Builder::lastActivatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastActivatedTime").build()}).build();
    private static final SdkField<String> LAST_ACTIVATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastActivatedBy").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::lastActivatedBy)).setter(EvaluationFormSearchSummary.setter(Builder::lastActivatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastActivatedBy").build()}).build();
    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatestVersion").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::latestVersion)).setter(EvaluationFormSearchSummary.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()}).build();
    private static final SdkField<Integer> ACTIVE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveVersion").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::activeVersion)).setter(EvaluationFormSearchSummary.setter(Builder::activeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_EVALUATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEvaluationEnabled").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::autoEvaluationEnabled)).setter(EvaluationFormSearchSummary.setter(Builder::autoEvaluationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationEnabled").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormLanguage").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::evaluationFormLanguageAsString)).setter(EvaluationFormSearchSummary.setter(Builder::evaluationFormLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormLanguage").build()}).build();
    private static final SdkField<String> CONTACT_INTERACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactInteractionType").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::contactInteractionTypeAsString)).setter(EvaluationFormSearchSummary.setter(Builder::contactInteractionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactInteractionType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(EvaluationFormSearchSummary.getter(EvaluationFormSearchSummary::tags)).setter(EvaluationFormSearchSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_ARN_FIELD, TITLE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LAST_ACTIVATED_TIME_FIELD, LAST_ACTIVATED_BY_FIELD, LATEST_VERSION_FIELD, ACTIVE_VERSION_FIELD, AUTO_EVALUATION_ENABLED_FIELD, EVALUATION_FORM_LANGUAGE_FIELD, CONTACT_INTERACTION_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormSearchSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationFormId;
    private final String evaluationFormArn;
    private final String title;
    private final String status;
    private final String description;
    private final Instant createdTime;
    private final String createdBy;
    private final Instant lastModifiedTime;
    private final String lastModifiedBy;
    private final Instant lastActivatedTime;
    private final String lastActivatedBy;
    private final Integer latestVersion;
    private final Integer activeVersion;
    private final Boolean autoEvaluationEnabled;
    private final String evaluationFormLanguage;
    private final String contactInteractionType;
    private final Map<String, String> tags;

    private EvaluationFormSearchSummary(BuilderImpl builder) {
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormArn = builder.evaluationFormArn;
        this.title = builder.title;
        this.status = builder.status;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastActivatedTime = builder.lastActivatedTime;
        this.lastActivatedBy = builder.lastActivatedBy;
        this.latestVersion = builder.latestVersion;
        this.activeVersion = builder.activeVersion;
        this.autoEvaluationEnabled = builder.autoEvaluationEnabled;
        this.evaluationFormLanguage = builder.evaluationFormLanguage;
        this.contactInteractionType = builder.contactInteractionType;
        this.tags = builder.tags;
    }

    public final String evaluationFormId() {
        return this.evaluationFormId;
    }

    public final String evaluationFormArn() {
        return this.evaluationFormArn;
    }

    public final String title() {
        return this.title;
    }

    public final EvaluationFormVersionStatus status() {
        return EvaluationFormVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastActivatedTime() {
        return this.lastActivatedTime;
    }

    public final String lastActivatedBy() {
        return this.lastActivatedBy;
    }

    public final Integer latestVersion() {
        return this.latestVersion;
    }

    public final Integer activeVersion() {
        return this.activeVersion;
    }

    public final Boolean autoEvaluationEnabled() {
        return this.autoEvaluationEnabled;
    }

    public final EvaluationFormLanguageCode evaluationFormLanguage() {
        return EvaluationFormLanguageCode.fromValue(this.evaluationFormLanguage);
    }

    public final String evaluationFormLanguageAsString() {
        return this.evaluationFormLanguage;
    }

    public final ContactInteractionType contactInteractionType() {
        return ContactInteractionType.fromValue(this.contactInteractionType);
    }

    public final String contactInteractionTypeAsString() {
        return this.contactInteractionType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactInteractionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSearchSummary)) {
            return false;
        }
        EvaluationFormSearchSummary other = (EvaluationFormSearchSummary)obj;
        return Objects.equals(this.evaluationFormId(), other.evaluationFormId()) && Objects.equals(this.evaluationFormArn(), other.evaluationFormArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastActivatedTime(), other.lastActivatedTime()) && Objects.equals(this.lastActivatedBy(), other.lastActivatedBy()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.activeVersion(), other.activeVersion()) && Objects.equals(this.autoEvaluationEnabled(), other.autoEvaluationEnabled()) && Objects.equals(this.evaluationFormLanguageAsString(), other.evaluationFormLanguageAsString()) && Objects.equals(this.contactInteractionTypeAsString(), other.contactInteractionTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormSearchSummary").add("EvaluationFormId", (Object)this.evaluationFormId()).add("EvaluationFormArn", (Object)this.evaluationFormArn()).add("Title", (Object)this.title()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreatedTime", (Object)this.createdTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastActivatedTime", (Object)this.lastActivatedTime()).add("LastActivatedBy", (Object)this.lastActivatedBy()).add("LatestVersion", (Object)this.latestVersion()).add("ActiveVersion", (Object)this.activeVersion()).add("AutoEvaluationEnabled", (Object)this.autoEvaluationEnabled()).add("EvaluationFormLanguage", (Object)this.evaluationFormLanguageAsString()).add("ContactInteractionType", (Object)this.contactInteractionTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationFormId": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormId()));
            }
            case "EvaluationFormArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormArn()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastActivatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastActivatedTime()));
            }
            case "LastActivatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastActivatedBy()));
            }
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "ActiveVersion": {
                return Optional.ofNullable(clazz.cast(this.activeVersion()));
            }
            case "AutoEvaluationEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationEnabled()));
            }
            case "EvaluationFormLanguage": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormLanguageAsString()));
            }
            case "ContactInteractionType": {
                return Optional.ofNullable(clazz.cast(this.contactInteractionTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("EvaluationFormArn", EVALUATION_FORM_ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastActivatedTime", LAST_ACTIVATED_TIME_FIELD);
        map.put("LastActivatedBy", LAST_ACTIVATED_BY_FIELD);
        map.put("LatestVersion", LATEST_VERSION_FIELD);
        map.put("ActiveVersion", ACTIVE_VERSION_FIELD);
        map.put("AutoEvaluationEnabled", AUTO_EVALUATION_ENABLED_FIELD);
        map.put("EvaluationFormLanguage", EVALUATION_FORM_LANGUAGE_FIELD);
        map.put("ContactInteractionType", CONTACT_INTERACTION_TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSearchSummary, T> g) {
        return obj -> g.apply((EvaluationFormSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationFormId;
        private String evaluationFormArn;
        private String title;
        private String status;
        private String description;
        private Instant createdTime;
        private String createdBy;
        private Instant lastModifiedTime;
        private String lastModifiedBy;
        private Instant lastActivatedTime;
        private String lastActivatedBy;
        private Integer latestVersion;
        private Integer activeVersion;
        private Boolean autoEvaluationEnabled;
        private String evaluationFormLanguage;
        private String contactInteractionType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSearchSummary model) {
            this.evaluationFormId(model.evaluationFormId);
            this.evaluationFormArn(model.evaluationFormArn);
            this.title(model.title);
            this.status(model.status);
            this.description(model.description);
            this.createdTime(model.createdTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastActivatedTime(model.lastActivatedTime);
            this.lastActivatedBy(model.lastActivatedBy);
            this.latestVersion(model.latestVersion);
            this.activeVersion(model.activeVersion);
            this.autoEvaluationEnabled(model.autoEvaluationEnabled);
            this.evaluationFormLanguage(model.evaluationFormLanguage);
            this.contactInteractionType(model.contactInteractionType);
            this.tags(model.tags);
        }

        public final String getEvaluationFormId() {
            return this.evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final String getEvaluationFormArn() {
            return this.evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationFormVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastActivatedTime() {
            return this.lastActivatedTime;
        }

        public final void setLastActivatedTime(Instant lastActivatedTime) {
            this.lastActivatedTime = lastActivatedTime;
        }

        @Override
        public final Builder lastActivatedTime(Instant lastActivatedTime) {
            this.lastActivatedTime = lastActivatedTime;
            return this;
        }

        public final String getLastActivatedBy() {
            return this.lastActivatedBy;
        }

        public final void setLastActivatedBy(String lastActivatedBy) {
            this.lastActivatedBy = lastActivatedBy;
        }

        @Override
        public final Builder lastActivatedBy(String lastActivatedBy) {
            this.lastActivatedBy = lastActivatedBy;
            return this;
        }

        public final Integer getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getActiveVersion() {
            return this.activeVersion;
        }

        public final void setActiveVersion(Integer activeVersion) {
            this.activeVersion = activeVersion;
        }

        @Override
        public final Builder activeVersion(Integer activeVersion) {
            this.activeVersion = activeVersion;
            return this;
        }

        public final Boolean getAutoEvaluationEnabled() {
            return this.autoEvaluationEnabled;
        }

        public final void setAutoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
        }

        @Override
        public final Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
            return this;
        }

        public final String getEvaluationFormLanguage() {
            return this.evaluationFormLanguage;
        }

        public final void setEvaluationFormLanguage(String evaluationFormLanguage) {
            this.evaluationFormLanguage = evaluationFormLanguage;
        }

        @Override
        public final Builder evaluationFormLanguage(String evaluationFormLanguage) {
            this.evaluationFormLanguage = evaluationFormLanguage;
            return this;
        }

        @Override
        public final Builder evaluationFormLanguage(EvaluationFormLanguageCode evaluationFormLanguage) {
            this.evaluationFormLanguage(evaluationFormLanguage == null ? null : evaluationFormLanguage.toString());
            return this;
        }

        public final String getContactInteractionType() {
            return this.contactInteractionType;
        }

        public final void setContactInteractionType(String contactInteractionType) {
            this.contactInteractionType = contactInteractionType;
        }

        @Override
        public final Builder contactInteractionType(String contactInteractionType) {
            this.contactInteractionType = contactInteractionType;
            return this;
        }

        @Override
        public final Builder contactInteractionType(ContactInteractionType contactInteractionType) {
            this.contactInteractionType(contactInteractionType == null ? null : contactInteractionType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public EvaluationFormSearchSummary build() {
            return new EvaluationFormSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormSearchSummary> {
        public Builder evaluationFormId(String var1);

        public Builder evaluationFormArn(String var1);

        public Builder title(String var1);

        public Builder status(String var1);

        public Builder status(EvaluationFormVersionStatus var1);

        public Builder description(String var1);

        public Builder createdTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastActivatedTime(Instant var1);

        public Builder lastActivatedBy(String var1);

        public Builder latestVersion(Integer var1);

        public Builder activeVersion(Integer var1);

        public Builder autoEvaluationEnabled(Boolean var1);

        public Builder evaluationFormLanguage(String var1);

        public Builder evaluationFormLanguage(EvaluationFormLanguageCode var1);

        public Builder contactInteractionType(String var1);

        public Builder contactInteractionType(ContactInteractionType var1);

        public Builder tags(Map<String, String> var1);
    }
}

