/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementCondition;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormItemEnablementConditionOperand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormItemEnablementConditionOperand> {
    private static final SdkField<EvaluationFormItemEnablementExpression> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Expression").getter(EvaluationFormItemEnablementConditionOperand.getter(EvaluationFormItemEnablementConditionOperand::expression)).setter(EvaluationFormItemEnablementConditionOperand.setter(Builder::expression)).constructor(EvaluationFormItemEnablementExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<EvaluationFormItemEnablementCondition> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Condition").getter(EvaluationFormItemEnablementConditionOperand.getter(EvaluationFormItemEnablementConditionOperand::condition)).setter(EvaluationFormItemEnablementConditionOperand.setter(Builder::condition)).constructor(EvaluationFormItemEnablementCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormItemEnablementConditionOperand.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationFormItemEnablementExpression expression;
    private final EvaluationFormItemEnablementCondition condition;
    private final Type type;

    private EvaluationFormItemEnablementConditionOperand(BuilderImpl builder) {
        this.expression = builder.expression;
        this.condition = builder.condition;
        this.type = builder.type;
    }

    public final EvaluationFormItemEnablementExpression expression() {
        return this.expression;
    }

    public final EvaluationFormItemEnablementCondition condition() {
        return this.condition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementConditionOperand)) {
            return false;
        }
        EvaluationFormItemEnablementConditionOperand other = (EvaluationFormItemEnablementConditionOperand)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.condition(), other.condition());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormItemEnablementConditionOperand").add("Expression", (Object)this.expression()).add("Condition", (Object)this.condition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationFormItemEnablementConditionOperand fromExpression(EvaluationFormItemEnablementExpression expression) {
        return (EvaluationFormItemEnablementConditionOperand)EvaluationFormItemEnablementConditionOperand.builder().expression(expression).build();
    }

    public static EvaluationFormItemEnablementConditionOperand fromExpression(Consumer<EvaluationFormItemEnablementExpression.Builder> expression) {
        EvaluationFormItemEnablementExpression.Builder builder = EvaluationFormItemEnablementExpression.builder();
        expression.accept(builder);
        return EvaluationFormItemEnablementConditionOperand.fromExpression((EvaluationFormItemEnablementExpression)builder.build());
    }

    public static EvaluationFormItemEnablementConditionOperand fromCondition(EvaluationFormItemEnablementCondition condition) {
        return (EvaluationFormItemEnablementConditionOperand)EvaluationFormItemEnablementConditionOperand.builder().condition(condition).build();
    }

    public static EvaluationFormItemEnablementConditionOperand fromCondition(Consumer<EvaluationFormItemEnablementCondition.Builder> condition) {
        EvaluationFormItemEnablementCondition.Builder builder = EvaluationFormItemEnablementCondition.builder();
        condition.accept(builder);
        return EvaluationFormItemEnablementConditionOperand.fromCondition((EvaluationFormItemEnablementCondition)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementConditionOperand, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementConditionOperand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EXPRESSION,
        CONDITION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationFormItemEnablementExpression expression;
        private EvaluationFormItemEnablementCondition condition;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementConditionOperand model) {
            this.expression(model.expression);
            this.condition(model.condition);
        }

        public final EvaluationFormItemEnablementExpression.Builder getExpression() {
            return this.expression != null ? this.expression.toBuilder() : null;
        }

        public final void setExpression(EvaluationFormItemEnablementExpression.BuilderImpl expression) {
            EvaluationFormItemEnablementExpression oldValue = this.expression;
            this.expression = expression != null ? expression.build() : null;
            this.handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
        }

        @Override
        public final Builder expression(EvaluationFormItemEnablementExpression expression) {
            EvaluationFormItemEnablementExpression oldValue = this.expression;
            this.expression = expression;
            this.handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
            return this;
        }

        public final EvaluationFormItemEnablementCondition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(EvaluationFormItemEnablementCondition.BuilderImpl condition) {
            EvaluationFormItemEnablementCondition oldValue = this.condition;
            this.condition = condition != null ? condition.build() : null;
            this.handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
        }

        @Override
        public final Builder condition(EvaluationFormItemEnablementCondition condition) {
            EvaluationFormItemEnablementCondition oldValue = this.condition;
            this.condition = condition;
            this.handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
            return this;
        }

        public EvaluationFormItemEnablementConditionOperand build() {
            return new EvaluationFormItemEnablementConditionOperand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormItemEnablementConditionOperand> {
        public Builder expression(EvaluationFormItemEnablementExpression var1);

        default public Builder expression(Consumer<EvaluationFormItemEnablementExpression.Builder> expression) {
            return this.expression((EvaluationFormItemEnablementExpression)((EvaluationFormItemEnablementExpression.Builder)EvaluationFormItemEnablementExpression.builder().applyMutation(expression)).build());
        }

        public Builder condition(EvaluationFormItemEnablementCondition var1);

        default public Builder condition(Consumer<EvaluationFormItemEnablementCondition.Builder> condition) {
            return this.condition((EvaluationFormItemEnablementCondition)((EvaluationFormItemEnablementCondition.Builder)EvaluationFormItemEnablementCondition.builder().applyMutation(condition)).build());
        }
    }
}

